"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _core = require("@kui-shell/core");

var _Input = _interopRequireDefault(require("./Input"));

var _Output = _interopRequireDefault(require("./Output"));

var _BlockModel = require("./BlockModel");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Block extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {};
  }
  /** Owner wants us to focus on the current prompt */


  doFocus() {
    if (this._input) {
      this._input.doFocus();
    }
  }

  inputValue() {
    return this._input && this._input.value();
  }

  output() {
    if ((0, _BlockModel.isFinished)(this.props.model) || (0, _BlockModel.isProcessing)(this.props.model)) {
      return React.createElement(_Output.default, {
        uuid: this.props.uuid,
        tab: this.props.tab,
        model: this.props.model,
        onRender: this.props.onOutputRender && (() => this.props.onOutputRender(this.props.idx)),
        isPinned: this.props.isPinned
      });
    }
  }

  willScreenshot() {
    if (this.props.willLoseFocus) {
      this.props.willLoseFocus();
    } // async, to allow willLoseFocus() to take affect


    setTimeout(() => {
      const element = this.state._block.querySelector('.kui--screenshotable') || this.state._block;

      _core.eventChannelUnsafe.emit('/screenshot/element', element);
    });
  }

  customInput() {
    if (this.props.children && React.isValidElement(this.props.children)) {
      return React.cloneElement(this.props.children, {
        idx: this.props.idx,
        tab: this.props.tab,
        uuid: this.props.uuid,
        block: this.state._block
      });
    }
  }

  input() {
    return this.customInput() || this.state._block && React.createElement(_Input.default, Object.assign({
      key: this.props.idx,
      uuid: this.props.uuid,
      tab: this.props.tab,
      model: this.props.model
    }, this.props, {
      willScreenshot: this.state._block && this.props.willRemove ? () => this.willScreenshot() : undefined,
      _block: this.state._block,
      ref: c => this._input = c
    }), this.props.children);
  }
  /**
   * For Active or Empty blocks, just show the <Input/>, otherwise
   * wrap the <Input/>-<Output/> pair.
   *
   */


  render() {
    return (!this.props.noActiveInput || !(0, _BlockModel.isActive)(this.props.model)) && React.createElement("div", {
      className: 'repl-block ' + this.props.model.state.toString(),
      "data-pinned": this.props.isPinned || undefined,
      "data-announcement": (0, _BlockModel.isAnnouncement)(this.props.model) || undefined,
      "data-uuid": (0, _BlockModel.hasUUID)(this.props.model) && this.props.model.execUUID,
      "data-input-count": this.props.idx,
      ref: c => this.setState({
        _block: c
      })
    }, (0, _BlockModel.isAnnouncement)(this.props.model) ? this.output() : (0, _BlockModel.isActive)(this.props.model) || (0, _BlockModel.isEmpty)(this.props.model) ? this.input() : React.createElement(React.Fragment, null, this.input(), this.output()));
  }

}

exports.default = Block;