"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _reactCore = require("@patternfly/react-core");

var _Markdown = _interopRequireDefault(require("../../../Content/Markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PatternflyCard extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      isOpen: false
    };
  }

  renderDropDownItems(actions) {
    return actions.map((item, idx) => React.createElement(_reactCore.DropdownItem, {
      key: idx,
      component: "button",
      onClick: item.handler,
      "data-mode": item.label
    }, item.label));
  }

  cardActions() {
    return React.createElement(_reactCore.CardActions, null, this.props.inlineActions, this.props.actions && React.createElement(_reactCore.Dropdown, {
      onSelect: () => this.setState({
        isOpen: !this.state.isOpen
      }),
      toggle: React.createElement(_reactCore.KebabToggle, {
        onToggle: isOpen => {
          this.setState({
            isOpen
          });
        }
      }),
      isOpen: this.state.isOpen,
      isPlain: true,
      dropdownItems: this.renderDropDownItems(this.props.actions),
      position: 'right'
    }));
  }

  icon() {
    return React.createElement(_reactCore.Brand, {
      src: this.props.icon,
      alt: "card icon",
      className: "kui--card-icon"
    });
  }
  /** card actions, icon and custom header node will be situated in Card Head */


  header() {
    return (this.props.header || this.props.icon || this.props.titleInHeader || this.props.bodyInHeader || this.props.inlineActions || this.props.actions) && React.createElement(_reactCore.CardHeader, {
      className: "kui--card-header"
    }, React.createElement(_reactCore.CardHeaderMain, null, this.props.header || this.props.icon && this.icon()), (this.props.inlineActions || this.props.actions) && this.cardActions(), React.createElement("div", null, this.props.titleInHeader && this.title(), this.props.bodyInHeader && this.body()));
  }
  /** card footer */


  footer() {
    return this.props.footer && React.createElement(_reactCore.CardFooter, {
      className: "kui--card-footer"
    }, this.props.footer);
  }

  title() {
    if (this.props.title) {
      return React.createElement(_reactCore.CardTitle, null, " ", this.props.title, " ");
    }
  }

  body() {
    if (Array.isArray(this.props.children)) {
      return this.props.children.map((child, idx) => React.createElement(_reactCore.CardBody, {
        className: "kui--card-body",
        key: idx
      }, child));
    } else {
      return React.createElement(_reactCore.CardBody, {
        className: "kui--card-body"
      }, typeof this.props.children === 'string' ? React.createElement(_Markdown.default, {
        source: this.props.children,
        repl: this.props.repl
      }) : this.props.children);
    }
  }

  render() {
    const basicClassName = 'kui--card small-top-pad small-bottom-pad';
    return React.createElement(_reactCore.Card, {
      isCompact: true,
      className: !this.props.className ? basicClassName : `${basicClassName} ${this.props.className}`
    }, React.Children.count(this.props.children) > 0 && React.createElement(React.Fragment, null, this.header(), !this.props.titleInHeader && this.title(), !this.props.bodyInHeader && this.body(), this.footer()));
  }

}

exports.default = PatternflyCard;