import { ParsedOptions } from '@kui-shell/core';
export interface BaseHistoryEntry {
    cwd: string;
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}
declare type InternalEntry<T extends BaseHistoryEntry> = T & {
    key: string;
    prev: number;
    next: number;
};
export default class CircularBuffer<T extends BaseHistoryEntry> {
    private readonly entries;
    private activeIdx;
    private prev;
    private next;
    private insertionIdx;
    private _length;
    constructor(first: T, capacity?: number);
    private entry;
    get length(): number;
    get key(): string;
    findIndex(predicate: (t: T, idx?: number, A?: T[]) => boolean): number;
    update(idx: number, t: T): void;
    /** update at this.activeIdx */
    updateActive(t: T): void;
    push(entry: T): void;
    /** pop the entry at idx */
    popAt(idx: number): void;
    before(): InternalEntry<T>;
    hasBefore(): boolean;
    hasAfter(): boolean;
    hasBuffer(): boolean;
    after(): InternalEntry<T>;
    hasLeft(): boolean;
    peek(): InternalEntry<T>;
    peekAt(idx: number): InternalEntry<T>;
}
export {};
