/**
 * API: arguments to plugin management
 *
 */
export declare namespace Plugins {
    /**
     * Recompile the plugin registry
     *
     * @param {string} [pluginToBeRemoved] when removing a plugin, it is
     * important to pass its name as this parameter, so that the command
     * registry cache can be updated without requiring a reload. You may
     * opt not to do so, but, in this case, a subsequent full reload is
     * mandatory; this will be the *caller's responsibility*.
     */
}
/**
 * Render the commands provided by a given plugin
 *
 * @param {string} [plugin] enumerate the commands offered by the
 * given plugin
 */
export declare const commandsOffered: (plugin?: string) => Promise<import("..").Table<import("..").Row>>;
/**
 * Home for user-installed plugins
 *
 */
export declare const userHome: () => Promise<string>;
export default Plugins;
