import { CodedError } from '../models/errors';
import { Entity } from '../models/entity';
import { CapabilityRequirements } from '../models/command';
interface UsageOptions {
    noHide?: boolean;
    noBreadcrumb?: boolean;
}
interface BreadcrumbWithClickCommand {
    label: string;
    command: string;
}
interface BreadcrumbWithLabelProvider {
    command: string;
}
declare type BreadcrumbLabel = string | BreadcrumbWithLabelProvider | BreadcrumbWithClickCommand;
export declare function isMessageWithUsageModel(msg: UsageLike): msg is MessageWithUsageModel;
interface DetailedExample {
    command: string;
    docs: string;
}
export interface UsageRow {
    commandPrefix?: string;
    commandSuffix?: string;
    command?: string;
    name?: string;
    label?: string;
    noclick?: boolean;
    synonyms?: string[];
    alias?: string;
    narg?: number;
    implicitOK?: string[];
    notNeededIfImplicit?: boolean;
    consumesPositional?: boolean;
    positional?: boolean;
    booleanOK?: boolean;
    boolean?: boolean;
    numeric?: boolean;
    file?: boolean;
    aliases?: string[];
    hidden?: boolean;
    advanced?: boolean;
    example?: string;
    dir?: boolean;
    title?: string;
    header?: string;
    docs?: string;
    partial?: boolean;
    defaultValue?: boolean | string | number;
    available?: UsageRow[];
    allowedIsPrefixMatch?: boolean;
    allowed?: (number | string | boolean)[];
}
interface UsageSection {
    title: string;
    rows: UsageRow[];
    nRowsInViewport?: number;
}
interface TitledContent {
    title: string;
    content: string;
}
declare type YargsParserConfigurationValue = string | boolean | number;
export interface YargsParserConfiguration {
    'camel-case-expansion'?: YargsParserConfigurationValue;
    'short-option-groups'?: YargsParserConfigurationValue;
    'duplicate-arguments-array'?: YargsParserConfigurationValue;
}
export interface UsageModel extends CapabilityRequirements {
    fn?: (command: string) => UsageModel;
    noHelp?: boolean;
    noHelpAlias?: boolean;
    onlyEnforceOptions?: boolean | string[];
    configuration?: YargsParserConfiguration;
    hide?: boolean;
    children?: Record<string, {
        route: string;
        usage?: UsageModel;
    }>;
    synonymFor?: string;
    synonyms?: string[];
    breadcrumb?: string;
    title?: string;
    command?: string;
    strict?: string;
    docs?: string;
    header?: string;
    example?: string;
    detailedExample?: DetailedExample | DetailedExample[];
    sampleInputs?: UsageRow[];
    intro?: TitledContent;
    sections?: UsageSection[];
    commandPrefix?: string;
    commandPrefixNotNeeded?: boolean;
    commandSuffix?: string;
    preserveCase?: boolean;
    parents?: BreadcrumbLabel[];
    related?: string[];
    available?: UsageRow[];
    required?: UsageRow[];
    optional?: UsageRow[];
    oneof?: UsageRow[];
    nRowsInViewport?: number | boolean;
}
interface MessageWithCode {
    message?: string;
    code?: number;
    exitCode?: number;
    statusCode?: number;
}
export interface MessageWithUsageModel extends MessageWithCode {
    messageDom?: MessageLike;
    usage?: UsageModel;
    extra?: any;
}
export declare function isMessageWithCode(msg: UsageLike): msg is MessageWithCode;
declare type MessageLike = string | HTMLElement;
declare type UsageLike = MessageLike | MessageWithUsageModel;
export interface UsageErrorLike {
    code?: number;
    statusCode?: number;
    message?: string;
    formattedMessage?: Promise<HTMLElement>;
    stack?: string;
    raw?: UsageLike;
}
export declare class UsageError extends Error implements CodedError, UsageErrorLike {
    formattedMessage: Promise<HTMLElement>;
    raw: UsageLike;
    code: number;
    constructor(message: UsageLike, extra?: UsageOptions);
    getUsageModel(): UsageModel;
    static getFormattedMessage(err: UsageErrorLike): Promise<HTMLElement>;
    static isUsageError(error: Entity | UsageErrorLike): error is UsageErrorLike;
}
export declare function isUsageError(error: Entity | UsageErrorLike): error is UsageErrorLike;
export default UsageError;
