/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { isHTML } from '../util/types';
import { isTable } from '../webapp/models/table';
import { isValidElement } from 'react';
export function isMessageBearingEntity(entity) {
    return entity.message !== undefined;
}
export function isMetadataBearing(spec) {
    const meta = spec;
    return meta !== undefined && meta.metadata !== undefined && meta.metadata.name !== undefined;
}
export function hasDisplayName(resource) {
    const res = resource;
    return isMetadataBearing(resource) && res.spec !== undefined && typeof res.spec.displayName === 'string';
}
export function isMetadataBearingByReference(spec) {
    const ref = spec;
    return ref !== undefined && ref.resource !== undefined && isMetadataBearing(ref.resource);
}
export function isMarkdownResponse(entity) {
    const md = entity;
    return md && typeof md.content === 'string' && md.contentType === 'text/markdown';
}
export function isReactResponse(entity) {
    const response = entity;
    return response && response.react && isValidElement(response.react);
}
export function isMixedResponse(response) {
    return (Array.isArray(response) &&
        response.length > 0 &&
        (typeof response[0] === 'string' || isTable(response[0]) || isHTML(response[0])));
}
export function isRawResponse(entity) {
    const raw = entity;
    return raw.mode === 'raw' && raw.content !== undefined;
}
//# sourceMappingURL=entity.js.map