/** the latest apiVersion */
export declare const apiVersion = "v2";
/** all known Theme apiVersions */
export declare type ThemeApiVersion = 'v1' | 'v2';
/** Properties that can be associated with <Kui/> component */
export interface ThemeProperties {
    components: 'carbon' | 'patternfly';
    topTabNames: 'command' | 'fixed';
}
declare type Theme = ThemeProperties & {
    apiVersion?: ThemeApiVersion;
    name: string;
    description?: string;
    css: string | string[];
    attrs?: string[];
    style: string;
};
export default Theme;
export interface ThemeSet {
    /** import path prefix for all themes */
    plugin: string;
    /** theme definitions */
    themes: Theme[];
}
