"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
let uid = 0;
/** Get props to conform to OUIA spec
 *
 * @param {string} componentType OUIA component type
 * @param {number|string} id OUIA component id
 * @param {boolean} ouiaSafe false if in animation
 */
function getOUIAProps(componentType, id, ouiaSafe = true) {
    return {
        'data-ouia-component-type': `PF4/${componentType}`,
        'data-ouia-safe': ouiaSafe,
        'data-ouia-component-id': id === undefined ? uid++ : id
    };
}
exports.getOUIAProps = getOUIAProps;
//# sourceMappingURL=ouia.js.map