"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var prefix = _carbonComponents.settings.prefix;

var props = function props() {
  return {
    className: 'some-class',
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Checkbox label'),
    indeterminate: (0, _addonKnobs.boolean)('Intermediate (indeterminate)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    wrapperClassName: (0, _addonKnobs.text)('Wrapper CSS class name (wrapperClassName)', ''),
    onChange: (0, _addonActions.action)('onChange')
  };
};

(0, _react2.storiesOf)('Checkbox', module).addDecorator(_addonKnobs.withKnobs).add('checked', function () {
  var checkboxProps = props();
  return _react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, _react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), _react.default.createElement(_Checkbox.default, _extends({
    defaultChecked: true
  }, checkboxProps, {
    id: "checkbox-label-1"
  })), _react.default.createElement(_Checkbox.default, _extends({
    defaultChecked: true
  }, checkboxProps, {
    id: "checkbox-label-2"
  })));
}, {
  info: {
    text: "\n        Checkboxes are used when there is a list of options and the user may select multiple options, including all or none.\n        The example below shows how the Checkbox component can be used as an uncontrolled component that is initially checked\n        by setting the defaultChecked property to true. To use the component in a controlled way, you should set the\n        checked property instead.\n      "
  }
}).add('unchecked', function () {
  var checkboxProps = props();
  return _react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, _react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), _react.default.createElement(_Checkbox.default, _extends({}, checkboxProps, {
    id: "checkbox-label-1"
  })), _react.default.createElement(_Checkbox.default, _extends({}, checkboxProps, {
    id: "checkbox-label-2"
  })));
}, {
  info: {
    text: "\n          Checkboxes are used when there is a list of options and the user may select multiple options, including all or none.\n          The example below shows how the Checkbox component can be used as an uncontrolled component that is initially\n          unchecked. To use the component in a controlled way, you should set the checked property instead.\n        "
  }
}).add('skeleton', function () {
  return _react.default.createElement("div", {
    "aria-label": "loading checkbox",
    "aria-live": "assertive",
    role: "status",
    tabindex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, _react.default.createElement(_Checkbox2.default, null));
}, {
  info: {
    text: "\n          Placeholder skeleton state to use when content is loading.\n        "
  }
});