"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchDelete = exports.deleteResource = exports.deleteSavedSearch = void 0;

var _HTTPClient = _interopRequireDefault(require("./HTTPClient"));

var lodash = _interopRequireWildcard(require("lodash"));

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _searchQueries = require("../definitions/search-queries");

var _pluginState = require("../pluginState");

var _search = require("./search");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

const deletedResources = [];

const deleteSavedSearch = args => new Promise(resolve => {
  if (args.argv.length === 1) {
    resolve('ERROR: Received wrong number of parameters.\nUSAGE: search -delete="save" <saved-search-name>');
  }

  const name = args.command.replace('search -delete="save" ', '');
  let warningToDelete = true;
  (0, _HTTPClient.default)('post', 'search', _searchQueries.SAVED_SEARCH_QUERY).then(res => {
    res.data.items.forEach(record => {
      if (record.name === name) {
        warningToDelete = false;
      }
    });

    if (warningToDelete) {
      res['warning'] = (0, _i18n.default)('modal.save.warning', [name]);
      resolve(res['warning']);
    } else {
      (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.DELETE_QUERY)(name)).then(resp => {
        if (resp.data.deleteSearch) {
          resolve((0, _i18n.default)('modal.deleted.save.success', [name]));
        } else {
          resolve(resp.errors[0]);
        }
      }).catch(err => {
        (0, _pluginState.setPluginState)('error', err);
        resolve((0, _search.renderSearchAvailable)());
      });
    }
  }).catch(err => {
    (0, _pluginState.setPluginState)('error', err);
    resolve((0, _search.renderSearchAvailable)());
  });
});

exports.deleteSavedSearch = deleteSavedSearch;

const deleteResource = args => new Promise(resolve => {
  if (args.argv.length !== 7) {
    resolve('ERROR: Received wrong number of parameters.\nUSAGE: search -delete="resource" <resource-name> <resource-namespace> <resource-kind> <resource-cluster> <resource-selfLink>');
  }

  (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.DELETE_RESOURCE)(args.argv[2], args.argv[3], args.argv[4], args.argv[5], args.argv[6])).then(res => {
    const data = lodash.get(res, 'data', '');

    if (data.deleteResource && !deletedResources.includes(args.argv[2])) {
      deletedResources.push(args.argv[2]);
      resolve(res.errors ? res.errors[0] : (0, _i18n.default)('modal.deleted.resource', [args.argv[2]]));
    } else {
      resolve((0, _i18n.default)('modal.delete.warning', [args.argv[2], args.argv[4]]));
    }
  }).catch(err => {
    (0, _pluginState.setPluginState)('error', err);
    resolve((0, _search.renderSearchAvailable)());
  });
});

exports.deleteResource = deleteResource;

const searchDelete = args => new Promise(resolve => {
  switch (args.argv[1]) {
    case '-delete="save"':
      resolve(deleteSavedSearch(args));
      break;

    case '-delete="resource"':
      resolve(deleteResource(args));
      break;

    default:
      resolve((0, _i18n.default)('delete.command.unknown.value'));
  }
});

exports.searchDelete = searchDelete;