"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteResource = exports.deleteSavedSearch = void 0;

var _i18n = _interopRequireDefault(require("../../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const deleteSavedSearch = {
  breadcrumb: 'deleteSavedSearch',
  command: 'deleteSavedSearch',
  title: (0, _i18n.default)('delete.savedsearchhelp.title'),
  header: (0, _i18n.default)('delete.savedsearchhelp.header'),
  example: 'deleteSavedSearch <saved-search-name>',
  available: [{
    docs: (0, _i18n.default)('delete.savedsearchhelp.title'),
    dir: true,
    commandSuffix: '-h'
  }],
  related: ['search', 'savedsearches', 'deleteResource']
};
exports.deleteSavedSearch = deleteSavedSearch;
const deleteResource = {
  breadcrumb: 'deleteResource',
  command: 'deleteResource',
  title: (0, _i18n.default)('delete.resourcehelp.title'),
  header: (0, _i18n.default)('delete.resourcehelp.header'),
  example: 'deleteResource <resource-name> <resource-namespace> <resource-kind> <resource-cluster> <resource-selfLink>',
  available: [{
    docs: (0, _i18n.default)('delete.resourcehelp.title'),
    dir: true,
    commandSuffix: '-h'
  }],
  related: ['search', 'savedsearches', 'deleteSavedSearch']
};
exports.deleteResource = deleteResource;