"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _resourceHelper = require("../util/resource-helper");

var _default = {
  application: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  applicationrelationship: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'source'
    }, {
      key: 'destination'
    }, {
      key: 'type'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  cluster: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'nodes'
    }, {
      key: 'klusterletVersion'
    }, {
      key: 'kubernetesVersion',
      msgKey: 'k8sVersion'
    }, {
      key: 'cpu'
    }, {
      key: 'storage'
    }, {
      key: 'memory'
    }],
    actions: []
  },
  configmap: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  cronjob: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'schedule'
    }, {
      key: 'suspend'
    }, {
      key: 'active'
    }, {
      key: 'lastSchedule',
      transform: _resourceHelper.getAge
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  daemonset: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'desired'
    }, {
      key: 'current'
    }, {
      key: 'ready'
    }, {
      key: 'updated'
    }, {
      key: 'available'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  deployable: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'chartUrl'
    }, {
      key: 'dependencies'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  deployment: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'desired'
    }, {
      key: 'current'
    }, {
      key: 'ready'
    }, {
      key: 'available'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  genericresource: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  job: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'completions'
    }, {
      key: 'parallelism'
    }, {
      key: 'successful'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  namespace: {
    columns: [{
      key: 'name'
    }, {
      key: 'cluster'
    }, {
      key: 'status'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  node: {
    columns: [{
      key: 'name'
    }, {
      key: 'cluster'
    }, {
      key: 'role'
    }, {
      key: 'architecture'
    }, {
      key: 'osImage'
    }, {
      key: 'cpu'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  persistentvolume: {
    columns: [{
      key: 'name'
    }, {
      key: 'cluster'
    }, {
      key: 'type'
    }, {
      key: 'status'
    }, {
      key: 'capacity'
    }, {
      key: 'accessModes',
      msgKey: 'accessMode'
    }, {
      key: 'claimRef',
      msgKey: 'claim'
    }, {
      key: 'reclaimPolicy'
    }, {
      key: 'path'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  persistentvolumeclaim: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'status'
    }, {
      key: 'persistentVolume',
      msgKey: 'persistent.volume'
    }, {
      key: 'requests'
    }, {
      key: 'accessModes',
      msgKey: 'accessMode'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  placementbinding: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'subjects'
    }, {
      key: 'placementpolicy'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  placementpolicy: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'replicas'
    }, {
      key: 'decisions'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  pod: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'status'
    }, {
      key: 'restarts'
    }, {
      key: 'hostIP'
    }, {
      key: 'podIP'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  policy: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'remediationAction'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  release: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'status'
    }, {
      key: 'chartName'
    }, {
      key: 'chartVersion'
    }, {
      key: 'updated',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  replicaset: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'desired'
    }, {
      key: 'current'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  savedSearches: {
    columns: [{
      key: 'name'
    }, {
      key: 'description'
    }, {
      key: 'searchText'
    }, {
      key: 'count'
    }],
    actions: []
  },
  secret: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'type'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }]
  },
  service: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  },
  statefulset: {
    columns: [{
      key: 'name'
    }, {
      key: 'namespace'
    }, {
      key: 'cluster'
    }, {
      key: 'desired'
    }, {
      key: 'current'
    }, {
      key: 'created',
      transform: _resourceHelper.getAge
    }],
    actions: []
  }
};
exports.default = _default;