"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logTab = exports.buildLog = void 0;

var lodash = _interopRequireWildcard(require("lodash"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _i18n = _interopRequireDefault(require("../../util/i18n"));

var _Logger = _interopRequireDefault(require("../../components/Logger"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const buildLog = data => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add('bx--structured-list--summary');
  const containers = lodash.get(data, 'container', '').replace(/,/g, '').split(' ');

  const logger = () => {
    return /*#__PURE__*/React.createElement(_Logger.default, {
      data: data,
      items: containers
    });
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(logger), node);
  return node;
};

exports.buildLog = buildLog;

const logTab = data => {
  return {
    mode: 'logging',
    label: (0, _i18n.default)('search.label.logs'),
    order: 3,
    content: buildLog(data)
  };
};

exports.logTab = logTab;