'use strict';
import * as React from 'react';
class Tag extends React.Component {
    getClassType(tag) {
        const { classNames } = this.props;
        switch (tag.classType) {
            case 'keyword':
                return 'react-tags__keyword-tag';
            default: return classNames.selectedTag;
        }
    }
    render() {
        const { classNames, onDelete, tag } = this.props;
        return (React.createElement("button", { type: 'button', className: this.getClassType(tag), onClick: onDelete },
            React.createElement("span", { className: classNames.selectedTagName }, tag.name)));
    }
}
export default Tag;
//# sourceMappingURL=Tag.js.map