import strings from '../../util/i18n';
import { getIntroduction } from './search-sidecar-help';
const contentType = 'text/html';
const apiVersion = 'kui-shell/v1';
const kind = 'NavResponse';
const sections = {
    introduction: {
        headers: [
            {
                header: strings('validation.about'),
                docs: strings('savedsearchhelp.title'),
                key: strings('validation.about')
            },
            {
                header: strings('validation.usage'),
                docs: strings('savedsearchhelp.header'),
                key: strings('validation.usage'),
                usage: `savedsearches (alias: ss)`
            },
            {
                header: strings('validation.guide'),
                docs: strings('validation.savedsearches.parameters'),
                key: strings('validation.guide')
            }
        ]
    }
};
export function usage() {
    return {
        apiVersion,
        kind,
        breadcrumbs: [{ label: 'savedsearches' }],
        menus: [{
                label: strings('validation.usage'),
                items: [{
                        mode: strings('validation.introduction'),
                        content: getIntroduction(sections.introduction.headers),
                        contentType
                    }]
            }],
        links: [
            { label: strings('validation.more.information'), href: 'https://github.com/open-cluster-management/rhacm-docs/blob/doc_stage/console/vwt_search.md#searching-with-visual-web-terminal' }
        ]
    };
}
//# sourceMappingURL=savedsearchhelp.js.map