"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _exec = _interopRequireDefault(require("./exec"));

var _apiVersion = _interopRequireDefault(require("./apiVersion"));

var _commandPrefix = _interopRequireDefault(require("../command-prefix"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function doGet(args) {
  return __awaiter(this, void 0, void 0, function* () {
    if ((0, _pluginKubectl.isUsage)(args)) {
      return (0, _pluginKubectl.doHelp)('helm', args);
    }

    const {
      command,
      argvNoOptions
    } = args;
    const projIdx = argvNoOptions.indexOf('get') + 1;
    const releaseIdx = argvNoOptions.length - 1;
    const projection = projIdx < releaseIdx ? argvNoOptions[projIdx] : undefined;
    const releaseName = argvNoOptions[releaseIdx];
    const basic = /REVISION:\s+(\S+)[\n\r]+RELEASED:\s+([^\n\r]+)[\n\r]+CHART:\s+(\S+)/;
    const response = yield (0, _exec.default)(args);

    if (projection) {
      return response;
    }

    const match = response.match(basic);

    if (!match) {
      // then this isn't of the form we expected; return the raw response
      return response;
    }

    const revision = match[1];
    const creationTimestamp = match[2];
    const endOfBasicSection = Math.min(response.indexOf('USER-SUPPLIED VALUES'), response.indexOf('COMPUTED VALUES'));
    return {
      apiVersion: _apiVersion.default,
      kind: 'HelmRelease',
      metadata: {
        name: releaseName,
        generation: revision,
        creationTimestamp
      },
      summary: {
        content: response.substring(0, endOfBasicSection).trim(),
        contentType: 'yaml'
      },
      isSimulacrum: true,
      originatingCommand: command,
      isKubeResource: true,
      kuiRawData: response,
      modes: []
    };
  });
}

var _default = registrar => {
  registrar.listen(`/${_commandPrefix.default}/helm/get`, doGet);
};

exports.default = _default;