import { Arguments, MultiModalResponse, Registrar } from '@kui-shell/core';
import { RawResponse } from './response';
import { KubeOptions } from './options';
import { KubeTableResponse } from '../../lib/view/formatTable';
import { KubeResource } from '../../lib/model/resource';
/**
 * `kubectl get` as a table response
 *
 */
export declare function doGetAsTable(command: string, args: Arguments<KubeOptions>, response: RawResponse, verb?: string, fullKind?: string): Promise<KubeTableResponse>;
/**
 * `kubectl get --watch` as a table response, but for the special case
 * where there is nothing yet to display
 *
 */
/**
 * `kubectl get` as entity response
 *
 */
export declare function doGetAsEntity(args: Arguments<KubeOptions>, response: RawResponse): Promise<KubeResource>;
/**
 * `kubectl get` as entity response
 *
 */
export declare function doGetAsMMR(args: Arguments<KubeOptions>, resource: KubeResource): Promise<MultiModalResponse<KubeResource>>;
export declare function rawGet(args: Arguments<KubeOptions>, _command?: string): Promise<RawResponse>;
/**
 * This is the main handler for `kubectl get`. Here, we act as a
 * dispatcher: in `kubectl` a `get` can mean either get-as-table,
 * get-as-entity, or get-as-custom, depending on the `-o` flag.
 *
 */
export declare const doGet: (command: string) => (args: Arguments<KubeOptions>) => Promise<import("@kui-shell/core/mdist/models/entity").Entity<any, import("@kui-shell/core").Row, import("@kui-shell/core").ResourceWithMetadata<any>>>;
/** KubeResource -> MultiModalResponse view transformer */
export declare function viewTransformer(args: Arguments<KubeOptions>, response: KubeResource): Promise<MultiModalResponse<KubeResource<import("../../lib/model/resource").KubeStatus, import("../../lib/model/resource").KubeMetadata>>>;
export declare const getFlags: import("@kui-shell/core").CommandOptions & {
    viewTransformer: typeof viewTransformer;
};
/** Register a command listener */
export declare function getter(registrar: Registrar, command: string, cli?: string): void;
declare const _default: (registrar: Registrar) => void;
export default _default;
