/*
 * Copyright 2018 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { i18n } from '@kui-shell/core';
import { Icons } from '@kui-shell/plugin-client-common';
import { isCrudableKubeResource as when } from '../../model/resource';
import { fqnOf } from '../../../controller/kubectl/fqn';
import { getCommandFromArgs } from '../../../lib/util/util';
const strings = i18n('plugin-kubectl');
/** Formulate the delete command line */
function command(tab, resource, args) {
    return `${getCommandFromArgs(args)} delete ${fqnOf(resource)}`;
}
/** The Delete button mode */
const mode = {
    icon: React.createElement(Icons, { icon: "Trash" }),
    mode: 'delete',
    order: 100,
    label: strings('deleteResource'),
    kind: 'drilldown',
    command,
    confirm: true
};
/** The DeleteButton mode registration: a `when` filter and a `mode` definition. */
export default {
    when,
    mode
};
//# sourceMappingURL=DeleteButton.js.map