"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusIcon = exports.status = void 0;

var React = _interopRequireWildcard(require("react"));

var lodash = _interopRequireWildcard(require("lodash"));

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const status = [{
  type: 'success',
  icon: /*#__PURE__*/React.createElement(_iconsReact.CheckmarkFilled16, {
    className: `status-success`
  }),
  values: ['Running', 'DEPLOYED', 'Active', 'OK', 'Available', 'Ready']
}, {
  type: 'warning',
  icon: /*#__PURE__*/React.createElement(_iconsReact.WarningFilled16, {
    className: `status-warning`
  }),
  values: ['Pending', 'Terminating', 'ContainerCreating']
}, {
  type: 'failed',
  icon: /*#__PURE__*/React.createElement(_iconsReact.ErrorFilled16, {
    className: `status-failed`
  }),
  values: ['Failed', 'CrashLoopBackOff', 'ImagePullBackOff', 'ErrImagePull', 'Error', 'OOMKilled', 'Init:OOMKilled']
}, {
  type: 'completed',
  icon: /*#__PURE__*/React.createElement(_iconsReact.CheckmarkFilled16, {
    className: `status-completed`
  }),
  values: ['Completed', 'Succeeded']
}, {
  type: 'unknown',
  icon: /*#__PURE__*/React.createElement(_iconsReact.Unknown16, {
    className: 'status-unknown'
  }),
  values: ['Unknown']
}];
exports.status = status;

const getStatusIcon = data => {
  const _ = status.filter(stat => stat.values.includes(data));

  return lodash.get(_, '[0].icon', '');
};

exports.getStatusIcon = getStatusIcon;