/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from 'react';
import { isViewButton } from '@kui-shell/core';
export default class ToolbarButton extends React.PureComponent {
    getCommand() {
        const { tab, response, button, args } = this.props;
        if (isViewButton(button)) {
            return button.command;
        }
        else {
            const cmd = typeof button.command === 'string' ? button.command : button.command(tab, response, args);
            if (button.confirm) {
                return `confirm "${cmd}"`;
            }
            else {
                return cmd;
            }
        }
    }
    buttonOnclick() {
        return __awaiter(this, void 0, void 0, function* () {
            const cmd = yield this.getCommand();
            const { tab, response, button, args } = this.props;
            if (typeof cmd === 'string') {
                if (isViewButton(button) || button.confirm) {
                    return tab.REPL.qexec(cmd, undefined, undefined, { rethrowErrors: true });
                }
                else {
                    return tab.REPL.pexec(cmd);
                }
            }
            else {
                cmd(tab, response, args);
            }
        });
    }
    render() {
        const { button } = this.props;
        return (React.createElement("a", { role: "presentation", href: "#", className: 'kui--tab-navigatable kui--notab-when-sidecar-hidden sidecar-bottom-stripe-button-as-button sidecar-bottom-stripe-button' +
                (button.icon ? ' kui--toolbar-button-with-icon' : ''), "data-mode": button.mode, onClick: this.buttonOnclick.bind(this) },
            React.createElement("span", { role: "tab", title: button.label || button.mode }, button.icon ? button.icon : button.label || button.mode)));
    }
}
//# sourceMappingURL=ToolbarButton.js.map