/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as React from 'react';
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle } from '@patternfly/react-core';
import Icons from '../../Icons';
import '../../../../../web/scss/components/DropDown/PatternFly.scss';
export default class PatternFlyDropDown extends React.PureComponent {
    renderDropDownItems(actions) {
        const renderItems = [];
        actions.forEach(item => {
            if (item.hasDivider) {
                renderItems.push(React.createElement(DropdownSeparator, { key: "separator" }));
            }
            renderItems.push(React.createElement(DropdownItem, { key: "action", component: "button", onClick: () => setTimeout(() => item.handler()), "data-mode": item.label },
                React.createElement("span", { className: "small-right-pad", style: !item.isSelected ? { opacity: 0 } : undefined },
                    React.createElement(Icons, { icon: "Checkmark", "data-mode": "selected container" })),
                item.label));
        });
        return renderItems;
    }
    render() {
        if (this.props.actions.length === 0) {
            return React.createElement(React.Fragment, null);
        }
        return (React.createElement(Dropdown, { className: this.props.className, onSelect: () => {
                this.setState(curState => ({ isOpen: !curState.isOpen }));
                if (this.props.onClose) {
                    this.props.onClose();
                }
            }, toggle: React.createElement(KebabToggle, { onToggle: isOpen => {
                    this.setState({ isOpen });
                } }), isOpen: this.state && this.state.isOpen, isPlain: true, dropdownItems: this.renderDropDownItems(this.props.actions), position: "right" }));
    }
}
//# sourceMappingURL=PatternFly.js.map