"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relatedTab = exports.buildRelated = void 0;

var lodash = _interopRequireWildcard(require("lodash"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _carbonComponentsReact = require("carbon-components-react");

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("../../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const handleEvent = (resource, event) => {
  var clusters = lodash.get(resource, 'items', '').map(res => res.cluster);
  clusters = clusters.filter((c, index) => clusters.indexOf(c) === index);

  if (event && event.which === 13 || !event) {
    let command = `search kind:${lodash.get(resource, 'kind', '')} `;

    if (clusters && lodash.get(resource, 'kind', '') !== 'cluster') {
      command += `cluster:${clusters.toString()} name:`;
    } else {
      command += 'name:';
    }

    lodash.get(resource, 'items', '').forEach(item => {
      command += `${item.name},`;
    });
    (0, _core.getCurrentTab)().REPL.pexec(command.substring(0, command.length - 1));
  }
};

const buildRelated = (data, type) => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add(type !== 'query' ? 'bx--structured-list--summary' : 'bx--tile-related');
  const relatedResource = type !== 'query' ? () => {
    return /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListWrapper, null, /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListBody, null, data.map(row => /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListRow, {
      key: `${row.kind}`,
      className: 'bx--structured-list-rowclick'
    }, /*#__PURE__*/React.createElement(_carbonComponentsReact.StructuredListCell, {
      tabIndex: 0,
      onKeyPress: e => handleEvent(row, e),
      onClick: () => handleEvent(row)
    }, /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-related-header'
    }, `${row.items.length}`), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-body'
    }, `Related ${row.kind}`))))));
  } : () => {
    return data.map(row => /*#__PURE__*/React.createElement(_carbonComponentsReact.Button, {
      className: `${row.kind}-related-button`,
      tabIndex: 0,
      key: row.kind,
      onClick: () => handleEvent(row),
      onKeyPress: e => handleEvent(row, e),
      type: "button"
    }, /*#__PURE__*/React.createElement("div", {
      className: 'bx--tile-container'
    }, /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-related-header'
    }, `${row.items.length}`), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("span", {
      className: 'bx--structured-list-td-body'
    }, `Related ${row.kind}`))));
  };
  ReactDOM.render( /*#__PURE__*/React.createElement(relatedResource), node);
  return node;
};

exports.buildRelated = buildRelated;

const relatedTab = (data, type) => {
  return {
    mode: 'related',
    label: (0, _i18n.default)('search.label.related'),
    order: 9999,
    content: buildRelated(data.related, type)
  };
};

exports.relatedTab = relatedTab;