/**
 * Assemble the plugin `PrescanModel`, and serialize it to disk. This
 * code is called both for assembling the model that is shipped with a
 * client, and (via `compileUserInstalled`, below) for assembling, on
 * the fly, the registry for user-installed plugins.
 *
 */
export declare const compile: (pluginRoot?: string, externalOnly?: boolean) => Promise<void>;
/**
 * The entry point for recompiling the user-installed plugin registry
 *
 */
export declare function compileUserInstalled(pluginToBeRemoved?: string): Promise<void>;
export default compile;
