import { Arguments } from '@kui-shell/core';
import { KubeOptions } from '../../controller/kubectl/options';
export interface TypedEntityName {
    type: string;
    fqn: string;
    actionName?: string;
    packageName?: string;
}
/**
 * If the given string is a Date, then return it in local time
 *
 */
export declare const maybeAsDate: (str: any) => any;
/**
 * Is the given filepath a directory?
 *
 */
export declare const isDirectory: (filepath: string) => Promise<boolean>;
/**
 * Turn a resource object into an OpenWhisk fully qualified name. This
 * assumes that resources have been "spread" so that there is one
 * OpenWhisk asset per spec.
 *
 */
export declare const toOpenWhiskFQN: ({ kind, spec, metadata }: {
    kind: any;
    spec: any;
    metadata: any;
}) => TypedEntityName;
export declare class StatusError extends Error {
}
export declare class TryLaterError extends StatusError {
}
export declare class NotFoundError extends StatusError {
    code: any;
    constructor(message: string, code?: any);
}
export declare const getCommandFromArgs: (args: {
    argvNoOptions: string[];
}) => string;
/**
 * Check if the command has verb but not resource. e.g. kubectl get
 * This is a special case since kubectl returns error instead of usage
 *
 */
export declare const commandWithoutResource: (args: Arguments<KubeOptions>) => boolean;
