"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var lodash = _interopRequireWildcard(require("lodash"));

var PropTypes = _interopRequireWildcard(require("prop-types"));

var _searchDefinitions = _interopRequireDefault(require("../definitions/search-definitions"));

var _Modal = _interopRequireDefault(require("./Modal"));

var _carbonComponentsReact = require("carbon-components-react");

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _iconsReact = require("@carbon/icons-react");

var _status = require("../util/status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

const {
  Table,
  TableHead,
  TableRow,
  TableBody,
  TableCell
} = _carbonComponentsReact.DataTable;
const PAGE_SIZES = {
  DEFAULT: 10,
  VALUES: [5, 10, 20, 50, 75, 100]
};

class ResourceTable extends React.PureComponent {
  constructor(props) {
    super(props);
    this.tabHeaders = ['name', 'action', 'share', 'edit'];

    this.toggleCollapseTable = () => {
      this.setState(({
        collapse
      }) => {
        return {
          collapse: !collapse
        };
      });
    };

    this.handleSort = selectedKey => () => {
      if (selectedKey) {
        this.setState(preState => {
          return {
            selectedKey,
            sortDirection: preState.sortDirection === 'asc' ? 'desc' : 'asc'
          };
        });
      }
    };

    this.handleEvent = (row, cell, e) => {
      if (e && e.which === 13 || !e) {
        const item = this.props.items.filter(data => data['name'] === lodash.get(row, '[0].value', ''));

        switch (cell.info['header']) {
          case 'action':
            this.setState({
              itemForAction: lodash.get(item, '[0]', ''),
              modalOpen: true,
              action: 'remove'
            });
            break;

          case 'edit':
            this.setState({
              itemForAction: lodash.get(item, '[0]', ''),
              modalOpen: true,
              action: 'edit'
            });
            break;

          case 'share':
            this.setState({
              itemForAction: lodash.get(item, '[0]', ''),
              modalOpen: true,
              action: 'share'
            });
            break;

          default:
            const headers = ['name', 'namespace', 'cluster'];
            let filters = '';

            const _ = row.filter(data => data && data.value && headers.includes(data.info['header']));

            _.forEach(data => {
              filters += `${data.info['header']}:${data.value} `;
            });

            if (this.props.kind === 'savedSearches' && cell.info['header'] === 'name') {
              return (0, _core.getCurrentTab)().REPL.pexec(`search ${row[2].value}`);
            } else if (cell.info['header'] === 'name' && filters) {
              return (0, _core.getCurrentTab)().REPL.pexec(`search summary kind:${this.props.kind} ${filters}`);
            } else {
              return null;
            }

        }
      }
    };

    this.state = {
      action: '',
      itemForAction: {},
      page: 1,
      pageSize: PAGE_SIZES.DEFAULT,
      sortDirection: 'asc',
      selectedKey: '',
      modalOpen: false,
      collapse: false
    };
    this.getHeaders = this.getHeaders.bind(this);
    this.getRows = this.getRows.bind(this);
    this.handleEvent = this.handleEvent.bind(this);
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      collapse: nextProps.collapseTable
    });
  }

  getHeaders() {
    const {
      kind
    } = this.props;
    const resource = _searchDefinitions.default[kind] || _searchDefinitions.default['genericresource'];
    const headers = resource.columns.map(col => ({
      key: col.key,
      header: (0, _i18n.default)(`table.header.${col.msgKey || col.key}`)
    }));
    headers.push({
      key: 'action',
      header: ''
    });

    if (kind === 'savedSearches') {
      headers.push({
        key: 'edit',
        header: ''
      });
      headers.push({
        key: 'share',
        header: ''
      });
    }

    return headers;
  }

  getRows() {
    let {
      items
    } = this.props;
    const {
      kind
    } = this.props;
    let transforms = _searchDefinitions.default[kind] || _searchDefinitions.default['genericresource'];
    const {
      page,
      pageSize,
      selectedKey,
      sortDirection
    } = this.state;

    if (selectedKey) {
      items = lodash.orderBy(items, [selectedKey], [sortDirection]);
    }

    const startItem = (page - 1) * pageSize;
    const visibleItems = items.slice(startItem, startItem + pageSize);
    transforms = transforms.columns.filter(rowCol => rowCol.transform);
    return visibleItems.map((item, i) => {
      const row = Object.assign({
        id: i.toString(),
        action: null
      }, item);

      if (transforms.length > 0) {
        transforms.forEach(transform => {
          row[transform.key] = transform.transform(item, null, transform.key);
        });
      }

      if (this.props.kind !== 'cluster' && this.props.kind !== 'release') {
        row.action = /*#__PURE__*/React.createElement(_iconsReact.Delete16, {
          className: 'table-action',
          onClick: () => this.setState({
            itemForAction: item,
            modalOpen: true,
            action: 'remove'
          })
        });

        if (kind === 'savedSearches') {
          row['share'] = /*#__PURE__*/React.createElement(_iconsReact.Share16, {
            className: 'table-action',
            onClick: () => this.setState({
              itemForAction: item,
              modalOpen: true,
              action: 'share'
            })
          });
          row['edit'] = /*#__PURE__*/React.createElement(_iconsReact.Edit16, {
            className: 'table-action',
            onClick: () => this.setState({
              itemForAction: item,
              modalOpen: true,
              action: 'edit'
            })
          });
        }
      }

      return row;
    });
  }

  render() {
    const {
      page,
      pageSize,
      sortDirection,
      selectedKey,
      modalOpen,
      collapse
    } = this.state;
    const totalItems = this.props.items.length;
    const sortColumn = selectedKey;
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
      className: 'search--resource-table-header'
    }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
      onClick: this.toggleCollapseTable,
      className: 'search--resource-table-header-button'
    }, /*#__PURE__*/React.createElement("span", {
      className: 'linked-resources'
    }, `${this.props.kind}(${this.props.items.length})`), !collapse ? /*#__PURE__*/React.createElement("span", {
      className: 'arrow-up'
    }, "\u25B2") : /*#__PURE__*/React.createElement("span", {
      className: 'arrow-down'
    }, "\u25BC")))), !collapse ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_carbonComponentsReact.DataTable, {
      key: `${this.props.kind}-resource-table`,
      rows: this.getRows(),
      headers: this.getHeaders(),
      render: ({
        rows,
        headers
      }) => {
        return /*#__PURE__*/React.createElement(Table, null, /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(header => /*#__PURE__*/React.createElement("th", {
          scope: 'col',
          key: header.key
        }, header.key !== 'action' ? /*#__PURE__*/React.createElement("div", {
          onClick: this.handleSort(header.key),
          className: `bx--table-sort-v2${sortDirection === 'asc' ? ' bx--table-sort-v2--ascending' : ''}${sortColumn === header.key ? ' bx--table-sort-v2--active' : ''}`,
          "data-key": header.key
        }, /*#__PURE__*/React.createElement("span", {
          className: 'bx--table-header-label'
        }, header.header, /*#__PURE__*/React.createElement("span", {
          className: 'arrow-header-label'
        }, this.state.sortDirection === 'asc' ? /*#__PURE__*/React.createElement("span", null, "\u25B2") : /*#__PURE__*/React.createElement("span", null, "\u25BC")))) : null)))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(row => /*#__PURE__*/React.createElement(TableRow, {
          key: row.id,
          className: 'bx--data-table--compact'
        }, row.cells.map(cell => /*#__PURE__*/React.createElement(TableCell, {
          onKeyPress: e => this.handleEvent(row.cells, cell, e),
          tabIndex: this.tabHeaders.includes(cell.info['header']) ? 0 : null,
          key: cell.id,
          onClick: () => this.handleEvent(row.cells, cell)
        }, cell.info['header'] !== 'status' ? cell.value : /*#__PURE__*/React.createElement("div", null, (0, _status.getStatusIcon)(cell.value), /*#__PURE__*/React.createElement("span", {
          className: `status-name`
        }, `${cell.value}`))))))));
      }
    }), this.props.items.length > PAGE_SIZES.DEFAULT ? /*#__PURE__*/React.createElement(_carbonComponentsReact.Pagination, {
      key: 'resource-table-pagination',
      id: 'resource-table-pagination',
      onChange: pagination => this.setState(pagination),
      pageSize: pageSize,
      pageSizes: PAGE_SIZES.VALUES,
      totalItems: totalItems,
      page: page,
      isLastPage: pageSize >= totalItems,
      itemsPerPageText: (0, _i18n.default)('pagination.itemsPerPage'),
      pageRangeText: (current, total) => (0, _i18n.default)('pagination.pageRange', [current, total]),
      itemRangeText: (min, max, total) => `${(0, _i18n.default)('pagination.itemRange', [min, max])} ${(0, _i18n.default)('pagination.itemRangeDescription', [total])}`,
      pageInputDisabled: pageSize >= totalItems
    }) : null) : null, /*#__PURE__*/React.createElement(_Modal.default, {
      item: this.state.itemForAction,
      modalOpen: modalOpen,
      onClose: () => this.setState({
        itemForAction: {},
        modalOpen: false,
        action: ''
      }),
      action: this.state.action
    }));
  }

}

exports.default = ResourceTable;
ResourceTable.propTypes = {
  collapseTable: PropTypes.bool,
  expandFullPage: PropTypes.bool,
  items: PropTypes.array,
  kind: PropTypes.string
};