import * as React from 'react';
import { IDisposable, editor as Monaco } from 'monaco-editor';
import { File } from '@kui-shell/plugin-bash-like/fs';
import { REPL, StringContent, ToolbarText, ToolbarProps, MultiModalResponse } from '@kui-shell/core';
import { Options as MonacoOptions } from './lib/defaults';
import '../../../../web/scss/components/Editor/Editor.scss';
declare type Props = MonacoOptions & ToolbarProps & {
    tabUUID: string;
    repl: REPL;
    content: StringContent;
    response: File | MultiModalResponse;
};
interface State {
    editor: Monaco.ICodeEditor;
    wrapper: HTMLDivElement;
    subscription?: IDisposable;
    toolbarText?: ToolbarText;
    catastrophicError: Error;
    cleaners: (() => void)[];
}
export default class Editor extends React.PureComponent<Props, State> {
    constructor(props: Props);
    static getDerivedStateFromError(error: Error): {
        catastrophicError: Error;
    };
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    /**
     * ToolbarText for a clean editor, i.e. no changes have been made
     * since last save.
     *
     */
    private static allClean;
    /**
     * ToolbarText to indicate error saving.
     *
     */
    private static error;
    /** Called whenever we have proposed (props,state); we derive a new State */
    static getDerivedStateFromProps(props: Props, state: State): Partial<State>;
    /** Called when this component is no longer attached to the document */
    componentWillUnmount(): void;
    /** Called when we no longer need the monaco-editor instance */
    private destroyMonaco;
    private static isClearable;
    private static onChange;
    /** Handle Toolbar registrations */
    private static subscribeToChanges;
    /** Called when we have a ready wrapper (monaco's init requires an wrapper */
    private static initMonaco;
    render(): JSX.Element;
}
export {};
