"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PatternFly4Icons;

var React = _interopRequireWildcard(require("react"));

var _reactIcons = require("@patternfly/react-icons");

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// we cannot find a good split icon from fontawesome
const size20 = {
  fontSize: '0.875em'
};
const size32 = {
  fontSize: '32px',
  padding: '3px'
};
const Sidecar = {
  fontSize: '1.125em'
};
const StatusStripe = Sidecar;
const Pagination = {
  fontSize: '1.5em'
};
/** helper to ensure exhaustiveness of the switch statement below */
// eslint-disable-next-line @typescript-eslint/no-unused-vars

function assertUnreachable(x) {
  throw new Error('Did not expect to get here');
}

function PatternFly4Icons(props) {
  switch (props.icon) {
    case 'At':
      return React.createElement(_reactIcons.AtIcon, Object.assign({
        style: StatusStripe
      }, props));

    case 'Add':
      return React.createElement(_reactIcons.PlusIcon, Object.assign({
        style: size20
      }, props));

    case 'Back':
      return React.createElement(_reactIcons.ArrowLeftIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'CodeBranch':
      return React.createElement(_reactIcons.CodeBranchIcon, Object.assign({
        style: StatusStripe
      }, props));

    case 'Checkmark':
      return React.createElement(_reactIcons.CheckCircleIcon, Object.assign({}, props));

    case 'Edit':
      return React.createElement(_reactIcons.EditIcon, Object.assign({}, props));

    case 'Error':
      return React.createElement(_reactIcons.BombIcon, Object.assign({}, props));

    case 'Forward':
      return React.createElement(_reactIcons.ArrowRightIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'Grid':
      return React.createElement(_reactIcons.ThIcon, Object.assign({}, props));

    case 'Info':
      return React.createElement(_reactIcons.InfoCircleIcon, Object.assign({}, props));

    case 'List':
      return React.createElement(_reactIcons.ListIcon, Object.assign({}, props));

    case 'Pause':
      return React.createElement(_reactIcons.PauseCircleIcon, Object.assign({}, props));

    case 'Play':
      return React.createElement(_reactIcons.PlayCircleIcon, Object.assign({}, props));

    case 'Retry':
      return React.createElement(_reactIcons.RebootingIcon, Object.assign({}, props));

    case 'PreviousPage':
      return React.createElement(_reactIcons.CaretLeftIcon, Object.assign({
        style: Pagination
      }, props));

    case 'Network':
      return React.createElement(_reactIcons.NetworkWiredIcon, Object.assign({}, props));

    case 'NextPage':
      return React.createElement(_reactIcons.CaretRightIcon, Object.assign({
        style: Pagination
      }, props));

    case 'Notification':
      return React.createElement(_reactIcons.BellIcon, Object.assign({}, props));

    case 'Server':
      return React.createElement(_reactIcons.ServerIcon, Object.assign({}, props));

    case 'Settings':
      return React.createElement(_reactIcons.QuestionCircleIcon, Object.assign({}, props));

    case 'Screenshot':
      return React.createElement(_reactIcons.CameraIcon, Object.assign({}, props));

    case 'ScreenshotInProgress':
      return React.createElement(_reactIcons.CameraRetroIcon, Object.assign({}, props));

    case 'Split':
      return React.createElement(_iconsReact.SplitScreen20, Object.assign({}, props));

    case 'Trash':
      return React.createElement(_reactIcons.TrashAltIcon, Object.assign({}, props));

    case 'TerminalOnly':
      return React.createElement(_reactIcons.OutlinedWindowMaximizeIcon, Object.assign({
        style: size32
      }, props));

    case 'TerminalPlusSidecar':
      return React.createElement(_reactIcons.ColumnsIcon, Object.assign({
        style: size32
      }, props));

    case 'Warning':
      return React.createElement(_reactIcons.ExclamationTriangleIcon, Object.assign({}, props));

    case 'Up':
      return React.createElement(_reactIcons.LevelUpAltIcon, Object.assign({}, props));

    case 'WindowClose':
      return React.createElement(_reactIcons.TimesIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'WindowMaximize':
      return React.createElement(_reactIcons.ExpandIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'WindowMinimize':
      return React.createElement(_reactIcons.CompressIcon, Object.assign({
        style: Sidecar
      }, props));
    // there's no icon for `TerminalPlusWatcher` and
    // `TerminalSidecarWatcher` in Patternfly, so we use carbon
    // icons for now

    case 'TerminalPlusWatcher':
      return React.createElement("div", null);

    case 'TerminalSidecarWatcher':
      return React.createElement("div", null);
  } // this bit of magic ensures exhaustiveness of the switch;
  // reference: https://stackoverflow.com/a/39419171


  return assertUnreachable(props.icon);
}