"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inDebugMode = inDebugMode;
Object.defineProperty(exports, "Kui", {
  enumerable: true,
  get: function () {
    return _Kui.default;
  }
});
Object.defineProperty(exports, "InputStripe", {
  enumerable: true,
  get: function () {
    return _InputStripe.default;
  }
});
Object.defineProperty(exports, "TabContainer", {
  enumerable: true,
  get: function () {
    return _TabContainer.default;
  }
});
Object.defineProperty(exports, "TabContent", {
  enumerable: true,
  get: function () {
    return _TabContent.default;
  }
});
Object.defineProperty(exports, "TabModel", {
  enumerable: true,
  get: function () {
    return _TabModel.default;
  }
});
Object.defineProperty(exports, "StatusStripe", {
  enumerable: true,
  get: function () {
    return _StatusStripe.default;
  }
});
Object.defineProperty(exports, "MeterWidgets", {
  enumerable: true,
  get: function () {
    return _MeterWidgets.default;
  }
});
Object.defineProperty(exports, "ContextWidgets", {
  enumerable: true,
  get: function () {
    return _ContextWidgets.default;
  }
});
Object.defineProperty(exports, "TextWithIconWidget", {
  enumerable: true,
  get: function () {
    return _TextWithIconWidget.default;
  }
});
Object.defineProperty(exports, "TagWidget", {
  enumerable: true,
  get: function () {
    return _TagWidget.default;
  }
});
Object.defineProperty(exports, "KuiContext", {
  enumerable: true,
  get: function () {
    return _context.default;
  }
});
Object.defineProperty(exports, "Loading", {
  enumerable: true,
  get: function () {
    return _Loading.default;
  }
});
Object.defineProperty(exports, "HTMLDom", {
  enumerable: true,
  get: function () {
    return _HTMLDom.default;
  }
});
Object.defineProperty(exports, "ComboSidecar", {
  enumerable: true,
  get: function () {
    return _ComboSidecar.default;
  }
});
Object.defineProperty(exports, "TopNavSidecar", {
  enumerable: true,
  get: function () {
    return _TopNavSidecar.default;
  }
});
Object.defineProperty(exports, "LeftNavSidecar", {
  enumerable: true,
  get: function () {
    return _LeftNavSidecar.default;
  }
});
Object.defineProperty(exports, "Card", {
  enumerable: true,
  get: function () {
    return _Card.default;
  }
});
Object.defineProperty(exports, "Tag", {
  enumerable: true,
  get: function () {
    return _Tag.default;
  }
});
Object.defineProperty(exports, "Alert", {
  enumerable: true,
  get: function () {
    return _Alert.default;
  }
});
Object.defineProperty(exports, "InputProvider", {
  enumerable: true,
  get: function () {
    return _Input.InputProvider;
  }
});
Object.defineProperty(exports, "defaultOnKeyDown", {
  enumerable: true,
  get: function () {
    return _OnKeyDown.default;
  }
});
Object.defineProperty(exports, "defaultOnKeyPress", {
  enumerable: true,
  get: function () {
    return _OnKeyPress.default;
  }
});
Object.defineProperty(exports, "defaultOnKeyUp", {
  enumerable: true,
  get: function () {
    return _ActiveISearch.onKeyUp;
  }
});
Object.defineProperty(exports, "Icons", {
  enumerable: true,
  get: function () {
    return _Icons.default;
  }
});
Object.defineProperty(exports, "DropDown", {
  enumerable: true,
  get: function () {
    return _DropDown.default;
  }
});

var _Kui = _interopRequireDefault(require("./components/Client/Kui"));

var _InputStripe = _interopRequireDefault(require("./components/Client/InputStripe"));

var _TabContainer = _interopRequireDefault(require("./components/Client/TabContainer"));

var _TabContent = _interopRequireDefault(require("./components/Client/TabContent"));

var _TabModel = _interopRequireDefault(require("./components/Client/TabModel"));

var _StatusStripe = _interopRequireDefault(require("./components/Client/StatusStripe"));

var _MeterWidgets = _interopRequireDefault(require("./components/Client/StatusStripe/MeterWidgets"));

var _ContextWidgets = _interopRequireDefault(require("./components/Client/StatusStripe/ContextWidgets"));

var _TextWithIconWidget = _interopRequireDefault(require("./components/Client/StatusStripe/TextWithIconWidget"));

var _TagWidget = _interopRequireDefault(require("./components/Client/StatusStripe/TagWidget"));

var _context = _interopRequireDefault(require("./components/Client/context"));

var _Loading = _interopRequireDefault(require("./components/spi/Loading"));

var _HTMLDom = _interopRequireDefault(require("./components/Content/Scalar/HTMLDom"));

var _ComboSidecar = _interopRequireDefault(require("./components/Views/Sidecar/ComboSidecar"));

var _TopNavSidecar = _interopRequireDefault(require("./components/Views/Sidecar/TopNavSidecar"));

var _LeftNavSidecar = _interopRequireDefault(require("./components/Views/Sidecar/LeftNavSidecar"));

var _Card = _interopRequireDefault(require("./components/spi/Card"));

var _Tag = _interopRequireDefault(require("./components/spi/Tag"));

var _Alert = _interopRequireDefault(require("./components/spi/Alert"));

var _Input = require("./components/Views/Terminal/Block/Input");

var _OnKeyDown = _interopRequireDefault(require("./components/Views/Terminal/Block/OnKeyDown"));

var _OnKeyPress = _interopRequireDefault(require("./components/Views/Terminal/Block/OnKeyPress"));

var _ActiveISearch = require("./components/Views/Terminal/Block/ActiveISearch");

var _Icons = _interopRequireDefault(require("./components/spi/Icons"));

var _DropDown = _interopRequireDefault(require("./components/spi/DropDown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Here we arrange the CSS for base functionality of Kui. Order is
 * preserved in the resulting <link> tags.
 *
 */
// default client
// Client components
// Content components
// sidecar components
// SPI
// Input components
// spi
function inDebugMode() {
  return typeof __KUI_RUNNING_KUI_TEST !== 'undefined' && __KUI_RUNNING_KUI_TEST || process.env.RUNNING_KUI_TEST || process.env.RUNNING_SHELL_TEST;
}