import { Arguments, Registrar, Tab, RadioTable, RadioTableRow, Table, Row, KResponse } from '@kui-shell/core';
import { KubeOptions } from './options';
/**
 * Summarize the resources in the namespace indicated by the last
 * positional argument into a table, where resources are histogrammed
 * by kind.
 *
 */
export declare function doSummarizeNamedNamespace(tab: Tab, ns: string): Promise<Table>;
/** Convert old Table row model to new RadioTable row model. */
export declare function t2rt({ name, attributes }: Row): RadioTableRow;
/** Function type that will actuate a namespace switch */
declare type SwitchFn = (ns: string, args: Arguments<KubeOptions>) => void;
/** Table -> RadioTable view transformer */
export declare function viewTransformer(doSwitch: SwitchFn, args: Arguments<KubeOptions>, response: KResponse): string | number | boolean | HTMLElement | Error | {
    content: string;
    contentType: "text/markdown";
} | import("@kui-shell/core").ReactResponse | import("@kui-shell/core").MixedResponse | Table<Row> | import("@kui-shell/core").NavResponse | RadioTable | import("@kui-shell/core").UsageModel | import("@kui-shell/core").ResourceWithMetadata<any> | import("@kui-shell/core").RawResponse<any> | import("@kui-shell/core").ResourceWithMetadata<any>[] | Promise<import("@kui-shell/core").MultiModalResponse<import("../../lib/model/resource").KubeResource<import("../../lib/model/resource").KubeStatus, import("../../lib/model/resource").KubeMetadata>>> | Promise<RadioTable>;
declare const _default: (commandTree: Registrar) => void;
export default _default;
