"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTab = isTab;
exports.getTabId = getTabId;
exports.getTabIds = getTabIds;
exports.getPrimaryTabId = getPrimaryTabId;
exports.pexecInCurrentTab = pexecInCurrentTab;
exports.getTab = exports.getCurrentTab = exports.sameTab = void 0;

/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isTab(node) {
  return node.classList.contains('kui--tab-content');
}
/**
 * Return the unique identifier for the given tab
 *
 */


function getTabId(tab) {
  return tab.uuid;
}

function getTabIds(tab) {
  const uuid = getTabId(tab);

  if (uuid) {
    const [u1] = uuid.split(/_/);
    return u1 === uuid ? [u1] : [u1, uuid];
  } else {
    return [];
  }
}

function getPrimaryTabId(tab) {
  return getTabIds(tab)[0];
}

const sameTab = (tab1, tab2) => {
  return getTabId(tab1) === getTabId(tab2);
};

exports.sameTab = sameTab;

const getCurrentTab = () => {
  return document.querySelector('.kui--tab-content.visible');
};

exports.getCurrentTab = getCurrentTab;

const getTab = idx => {
  if (!idx) {
    return getCurrentTab();
  } else if (typeof idx === 'number') {
    return document.querySelector(`.kui--tab-content[data-tab-id="${idx}"]`);
  } else {
    return idx;
  }
};

exports.getTab = getTab;

function pexecInCurrentTab(command) {
  const {
    facade: tab
  } = document.querySelector('.kui--tab-content.visible .kui--scrollback');
  return tab.REPL.pexec(command, {
    tab
  });
}