function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import ReactDOM from 'react-dom';
import { action } from '@storybook/addon-actions';
import { boolean, object, optionsKnob as options, select, text, withKnobs } from '@storybook/addon-knobs';
import ComposedModal, { ModalHeader, ModalBody, ModalFooter } from '../ComposedModal';
import Select from '../Select';
import SelectItem from '../SelectItem';
import TextInput from '../TextInput';
import Button from '../Button';
import mdx from './ComposedModal.mdx';
var sizes = {
  'Extra small (xs)': 'xs',
  'Small (sm)': 'sm',
  'Medium (md)': 'md',
  'Large (lg)': 'lg'
};
var buttons = {
  'None (0)': '0',
  'One (1)': '1',
  'Two (2)': '2',
  'Three (3)': '3'
};
var props = {
  composedModal: function composedModal() {
    return {
      numberOfButtons: options('Number of Buttons', buttons, '2', {
        display: 'inline-radio'
      }),
      open: boolean('Open (open in <ComposedModal>)', true),
      onKeyDown: action('onKeyDown'),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', '[data-modal-primary-focus]'),
      size: select('Size (size)', sizes, 'md'),
      preventCloseOnClickOutside: boolean('Prevent closing on click outside of modal (preventCloseOnClickOutside)', true)
    };
  },
  modalHeader: function modalHeader() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        titleOnly = _ref.titleOnly;

    return {
      label: text('Optional Label (label in <ModalHeader>)', 'Label'),
      title: text('Optional title (title in <ModalHeader>)', titleOnly ? "\n      Passive modal title as the message. Should be direct and 3 lines or less.\n    ".trim() : 'Modal heading'),
      iconDescription: text('Close icon description (iconDescription in <ModalHeader>)', 'Close'),
      buttonOnClick: action('buttonOnClick')
    };
  },
  modalBody: function modalBody() {
    return {
      hasScrollingContent: boolean('Modal contains scrollable content (hasScrollingContent)', false),
      'aria-label': text('ARIA label for content', 'Example modal content')
    };
  },
  modalFooter: function modalFooter(numberOfButtons) {
    var secondaryButtons = function secondaryButtons() {
      switch (numberOfButtons) {
        case '2':
          return {
            secondaryButtonText: text('Secondary button text (secondaryButtonText in <ModalFooter>)', 'Secondary button')
          };

        case '3':
          return {
            secondaryButtons: object('Secondary button config array (secondaryButtons)', [{
              buttonText: 'Keep both',
              onClick: action('onClick')
            }, {
              buttonText: 'Rename',
              onClick: action('onClick')
            }])
          };

        default:
          return null;
      }
    };

    return _objectSpread(_objectSpread({
      danger: boolean('Primary button danger (danger)', false),
      primaryButtonText: text('Primary button text (primaryButtonText in <ModalFooter>)', 'Primary button'),
      primaryButtonDisabled: boolean('Primary button disabled (primaryButtonDisabled in <ModalFooter>)', false)
    }, secondaryButtons(numberOfButtons)), {}, {
      onRequestClose: action('onRequestClose'),
      onRequestSubmit: action('onRequestSubmit')
    });
  }
};
var scrollingContent = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("h3", null, "Lorem ipsum"), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '));
export default {
  title: 'Components/ComposedModal',
  decorators: [withKnobs],
  parameters: {
    component: ComposedModal,
    subcomponents: {
      ModalHeader: ModalHeader,
      ModalBody: ModalBody,
      ModalFooter: ModalFooter
    },
    docs: {
      page: mdx
    }
  }
};
export var Playground = function Playground() {
  var _props$composedModal = props.composedModal(),
      size = _props$composedModal.size,
      numberOfButtons = _props$composedModal.numberOfButtons,
      rest = _objectWithoutProperties(_props$composedModal, ["size", "numberOfButtons"]);

  var _props$modalBody = props.modalBody(),
      hasScrollingContent = _props$modalBody.hasScrollingContent;

  return /*#__PURE__*/React.createElement(ComposedModal, _extends({}, rest, {
    size: size || undefined
  }), /*#__PURE__*/React.createElement(ModalHeader, props.modalHeader()), /*#__PURE__*/React.createElement(ModalBody, _extends({}, props.modalBody(), {
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }), /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/React.createElement("br", null), hasScrollingContent && scrollingContent), numberOfButtons > 0 && /*#__PURE__*/React.createElement(ModalFooter, props.modalFooter(numberOfButtons)));
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(ComposedModal, {
    open: true
  }, /*#__PURE__*/React.createElement(ModalHeader, {
    label: "Account resources",
    title: "Add a custom domain"
  }), /*#__PURE__*/React.createElement(ModalBody, null, /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  }))), /*#__PURE__*/React.createElement(ModalFooter, {
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel"
  }));
};
Default.story = {
  name: 'Composed Modal'
};
export var PassiveModal = function PassiveModal() {
  return /*#__PURE__*/React.createElement(ComposedModal, {
    open: true
  }, /*#__PURE__*/React.createElement(ModalHeader, {
    title: "You have been successfully signed out"
  }), /*#__PURE__*/React.createElement(ModalBody, null));
};
export var WithStateManager = function WithStateManager() {
  /**
   * Simple state manager for modals.
   */
  var ModalStateManager = function ModalStateManager(_ref2) {
    var LauncherContent = _ref2.renderLauncher,
        ModalContent = _ref2.children;

    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        open = _useState2[0],
        setOpen = _useState2[1];

    return /*#__PURE__*/React.createElement(React.Fragment, null, !ModalContent || typeof document === 'undefined' ? null : /*#__PURE__*/ReactDOM.createPortal( /*#__PURE__*/React.createElement(ModalContent, {
      open: open,
      setOpen: setOpen
    }), document.body), LauncherContent && /*#__PURE__*/React.createElement(LauncherContent, {
      open: open,
      setOpen: setOpen
    }));
  };

  return /*#__PURE__*/React.createElement(ModalStateManager, {
    renderLauncher: function renderLauncher(_ref3) {
      var setOpen = _ref3.setOpen;
      return /*#__PURE__*/React.createElement(Button, {
        onClick: function onClick() {
          return setOpen(true);
        }
      }, "Launch composed modal");
    }
  }, function (_ref4) {
    var open = _ref4.open,
        setOpen = _ref4.setOpen;
    return /*#__PURE__*/React.createElement(ComposedModal, {
      open: open,
      onClose: function onClose() {
        return setOpen(false);
      }
    }, /*#__PURE__*/React.createElement(ModalHeader, {
      label: "Account resources",
      title: "Add a custom domain"
    }), /*#__PURE__*/React.createElement(ModalBody, null, /*#__PURE__*/React.createElement("p", {
      style: {
        marginBottom: '1rem'
      }
    }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
      "data-modal-primary-focus": true,
      id: "text-input-1",
      labelText: "Domain name",
      placeholder: "e.g. github.com",
      style: {
        marginBottom: '1rem'
      }
    }), /*#__PURE__*/React.createElement(Select, {
      id: "select-1",
      defaultValue: "us-south",
      labelText: "Region"
    }, /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-south",
      text: "US South"
    }), /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-east",
      text: "US East"
    }))), /*#__PURE__*/React.createElement(ModalFooter, {
      primaryButtonText: "Add",
      secondaryButtonText: "Cancel"
    }));
  });
};