function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './stories/datatable-story.scss';
import { action } from '@storybook/addon-actions';
import React from 'react';
import { withKnobs, boolean, select } from '@storybook/addon-knobs';
import Button from '../Button';
import Checkbox from '../Checkbox';
import OverflowMenu from '../OverflowMenu';
import OverflowMenuItem from '../OverflowMenuItem';
import { default as DataTable, TableContainer, Table, TableHead, TableRow, TableHeader, TableBody, TableCell, TableToolbar, TableToolbarAction, TableToolbarContent, TableToolbarSearch, TableToolbarMenu } from '../DataTable';
import mdx from './DataTable.mdx';
import { headers, rows } from './stories/shared';

var props = function props() {
  return {
    useZebraStyles: boolean('Zebra row styles (useZebraStyles)', false),
    size: select('Row height (size)', {
      'Extra small (xs)': 'xs',
      'Small (sm)': 'sm',
      'Medium (md)': 'md',
      'Large (lg) - default': 'lg',
      'Extra Large (xl)': 'xl'
    }, 'lg'),
    stickyHeader: boolean('Sticky header (experimental)', false)
  };
};

export default {
  title: 'Components/DataTable',
  component: DataTable,
  subcomponents: {
    TableContainer: TableContainer,
    Table: Table,
    TableHead: TableHead,
    TableRow: TableRow,
    TableHeader: TableHeader,
    TableBody: TableBody,
    TableCell: TableCell
  },
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var Usage = function Usage() {
  return /*#__PURE__*/React.createElement(DataTable, _extends({
    rows: rows,
    headers: headers
  }, props()), function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "Usage example"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, _extends({}, getTableProps(), {
      isSortable: true
    }), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: header.key
      }, getHeaderProps({
        header: header
      }), {
        isSortable: true
      }), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};
export var BasicTable = function BasicTable() {
  var rows = [{
    id: 'load-balancer-1',
    name: 'Load Balancer 1',
    rule: 'Round robin',
    Status: 'Starting'
  }, {
    id: 'load-balancer-2',
    name: 'Load Balancer 2',
    rule: 'DNS delegation',
    status: 'Active'
  }, {
    id: 'load-balancer-3',
    name: 'Load Balancer 3',
    rule: 'Round robin',
    status: 'Disabled'
  }];
  var headers = ['Name', 'Rule', 'Status'];
  return /*#__PURE__*/React.createElement(Table, null, /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
    return /*#__PURE__*/React.createElement(TableHeader, {
      key: header
    }, header);
  }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
    return /*#__PURE__*/React.createElement(TableRow, {
      key: row.id
    }, Object.keys(row).filter(function (key) {
      return key !== 'id';
    }).map(function (key) {
      return /*#__PURE__*/React.createElement(TableCell, {
        key: key
      }, row[key]);
    }));
  })));
};
export var WithOverflowMenu = function WithOverflowMenu() {
  return /*#__PURE__*/React.createElement(DataTable, _extends({
    rows: rows,
    headers: headers
  }, props()), function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getTableProps = _ref2.getTableProps;
    return /*#__PURE__*/React.createElement(TableContainer, {
      title: "DataTable",
      description: "With overflow menu"
    }, /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }), /*#__PURE__*/React.createElement(TableHeader, null))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }), /*#__PURE__*/React.createElement(TableCell, {
        className: "bx--table-column-menu"
      }, /*#__PURE__*/React.createElement(OverflowMenu, {
        size: "sm",
        light: true,
        flipped: true
      }, /*#__PURE__*/React.createElement(OverflowMenuItem, null, "Action 1"), /*#__PURE__*/React.createElement(OverflowMenuItem, null, "Action 2"), /*#__PURE__*/React.createElement(OverflowMenuItem, null, "Action 3"))));
    }))));
  });
};
export var WithToolbar = function WithToolbar() {
  return /*#__PURE__*/React.createElement(DataTable, _extends({
    rows: rows,
    headers: headers
  }, props()), function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getTableProps = _ref3.getTableProps,
        getToolbarProps = _ref3.getToolbarProps,
        onInputChange = _ref3.onInputChange,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With toolbar"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(TableToolbar, _extends({}, getToolbarProps(), {
      "aria-label": "data table toolbar"
    }), /*#__PURE__*/React.createElement(TableToolbarContent, null, /*#__PURE__*/React.createElement(TableToolbarSearch, {
      onChange: onInputChange
    }), /*#__PURE__*/React.createElement(TableToolbarMenu, {
      light: true
    }, /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 1 Click')
    }, "Action 1"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 2 Click')
    }, "Action 2"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 3 Click')
    }, "Action 3")), /*#__PURE__*/React.createElement(Button, {
      onClick: action('Button click')
    }, "Primary Button"))), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};
export var WithCheckmarkColumns = function WithCheckmarkColumns() {
  var rows = [{
    id: 'a',
    name: 'Load Balancer 3',
    protocol: 'HTTP',
    port: 3000,
    rule: 'Round robin',
    attached_groups: 'Kevin’s VM Groups',
    status: 'Disabled',
    enabled: true
  }, {
    id: 'b',
    name: 'Load Balancer 1',
    protocol: 'HTTP',
    port: 443,
    rule: 'Round robin',
    attached_groups: 'Maureen’s VM Groups',
    status: 'Starting',
    enabled: true
  }, {
    id: 'c',
    name: 'Load Balancer 2',
    protocol: 'HTTP',
    port: 80,
    rule: 'DNS delegation',
    attached_groups: 'Andrew’s VM Groups',
    status: 'Active',
    enabled: false
  }];
  var headers = [{
    key: 'name',
    header: 'Name'
  }, {
    key: 'protocol',
    header: 'Protocol'
  }, {
    key: 'port',
    header: 'Port'
  }, {
    key: 'rule',
    header: 'Rule'
  }, {
    key: 'attached_groups',
    header: 'Attached Groups'
  }, {
    key: 'status',
    header: 'Status'
  }, {
    key: 'enabled',
    header: 'Enabled'
  }];
  return /*#__PURE__*/React.createElement(DataTable, _extends({
    rows: rows,
    headers: headers
  }, props()), function (_ref4) {
    var rows = _ref4.rows,
        headers = _ref4.headers,
        getHeaderProps = _ref4.getHeaderProps,
        getRowProps = _ref4.getRowProps,
        getTableProps = _ref4.getTableProps,
        getTableContainerProps = _ref4.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With boolean column"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        if (cell.info.header === 'enabled') {
          return /*#__PURE__*/React.createElement(TableCell, {
            key: cell.id,
            id: cell.id,
            className: "la-".concat(cell.info.header)
          }, /*#__PURE__*/React.createElement(Checkbox, {
            id: 'check-' + cell.id,
            hideLabel: true,
            labelText: "checkbox"
          }));
        } else {
          return /*#__PURE__*/React.createElement(TableCell, {
            key: cell.id
          }, cell.value);
        }
      }));
    }))));
  });
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(DataTable, _extends({
    rows: rows,
    headers: headers
  }, props(), {
    render: function render(_ref5) {
      var rows = _ref5.rows,
          headers = _ref5.headers,
          getHeaderProps = _ref5.getHeaderProps,
          getRowProps = _ref5.getRowProps,
          getTableProps = _ref5.getTableProps,
          getTableContainerProps = _ref5.getTableContainerProps;
      return /*#__PURE__*/React.createElement(TableContainer, _extends({
        title: "DataTable",
        description: "With default options"
      }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header, i) {
        return /*#__PURE__*/React.createElement(TableHeader, _extends({
          key: i
        }, getHeaderProps({
          header: header
        })), header.header);
      }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row, i) {
        return /*#__PURE__*/React.createElement(TableRow, _extends({
          key: i
        }, getRowProps({
          row: row
        })), row.cells.map(function (cell) {
          return /*#__PURE__*/React.createElement(TableCell, {
            key: cell.id
          }, cell.value);
        }));
      }))));
    }
  }));
};