function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Close16, WarningFilled16, CheckmarkFilled16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import PropTypes from 'prop-types';
import React from 'react';
import Loading from '../Loading';
var prefix = settings.prefix;

function Filename(_ref) {
  var iconDescription = _ref.iconDescription,
      status = _ref.status,
      invalid = _ref.invalid,
      rest = _objectWithoutProperties(_ref, ["iconDescription", "status", "invalid"]);

  switch (status) {
    case 'uploading':
      return /*#__PURE__*/React.createElement(Loading, {
        description: iconDescription,
        small: true,
        withOverlay: false
      });

    case 'edit':
      return /*#__PURE__*/React.createElement(React.Fragment, null, invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
        className: "".concat(prefix, "--file-invalid")
      }), /*#__PURE__*/React.createElement("button", _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-close"),
        type: "button"
      }, rest), /*#__PURE__*/React.createElement(Close16, null)));

    case 'complete':
      return /*#__PURE__*/React.createElement(CheckmarkFilled16, _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-complete")
      }, rest), iconDescription && /*#__PURE__*/React.createElement("title", null, iconDescription));

    default:
      return null;
  }
}

Filename.propTypes = {
  /**
   * Provide a description of the SVG icon to denote file upload status
   */
  iconDescription: PropTypes.string,

  /**
   * Specify if the file is invalid
   */
  invalid: PropTypes.bool,

  /**
   * Status of the file upload
   */
  status: PropTypes.oneOf(['edit', 'complete', 'uploading']),

  /**
   * Provide a custom tabIndex value for the <Filename>
   */
  tabIndex: PropTypes.string
};
Filename.defaultProps = {
  iconDescription: 'Uploading file',
  status: 'uploading',
  tabIndex: '0'
};
export default Filename;