function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import setupGetInstanceId from '../../../tools/setupGetInstanceId';
import Select from '../../Select';
import SelectItem from '../../SelectItem';
var prefix = settings.prefix;
var getInstanceId = setupGetInstanceId();

function PageSelector(_ref) {
  var className = _ref.className,
      currentPage = _ref.currentPage,
      id = _ref.id,
      labelText = _ref.labelText,
      totalPages = _ref.totalPages,
      other = _objectWithoutProperties(_ref, ["className", "currentPage", "id", "labelText", "totalPages"]);

  var namespace = "".concat(prefix, "--unstable-pagination__page-selector");
  var instanceId = "".concat(namespace, "__select-").concat(getInstanceId());

  var renderPages = function renderPages(total) {
    var pages = [];

    for (var counter = 1; counter <= total; counter += 1) {
      pages.push( /*#__PURE__*/React.createElement(SelectItem, {
        key: counter,
        value: counter,
        text: String(counter)
      }));
    }

    return pages;
  };

  return /*#__PURE__*/React.createElement(Select, _extends({
    className: classnames(namespace, className),
    hideLabel: true,
    id: instanceId || id,
    inline: true,
    labelText: labelText,
    value: currentPage
  }, other), renderPages(totalPages));
}

PageSelector.propTypes = {
  /** Extra class names to add. */
  className: PropTypes.string,

  /** The current page. */
  currentPage: PropTypes.number.isRequired,

  /** The unique ID of this component instance. */
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /** Translatable string to label the page selector element. */
  labelText: PropTypes.string,

  /**
   * Total number of pages.
   * This value is calculated using a valid `totalItems` prop passed to the parent `Unstable_Pagination`.
   */
  totalPages: PropTypes.number.isRequired
};
PageSelector.defaultProps = {
  className: null,
  id: 1,
  labelText: 'Current page number'
};
export default PageSelector;