function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { ChevronDown16, WarningFilled16, WarningAltFilled16 } from '@carbon/icons-react';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;
var Select = /*#__PURE__*/React.forwardRef(function Select(_ref, ref) {
  var _classNames, _classNames2, _classNames3;

  var className = _ref.className,
      id = _ref.id,
      inline = _ref.inline,
      labelText = _ref.labelText,
      disabled = _ref.disabled,
      children = _ref.children,
      noLabel = _ref.noLabel,
      iconDescription = _ref.iconDescription,
      hideLabel = _ref.hideLabel,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      helperText = _ref.helperText,
      light = _ref.light,
      size = _ref.size,
      warn = _ref.warn,
      warnText = _ref.warnText,
      other = _objectWithoutProperties(_ref, ["className", "id", "inline", "labelText", "disabled", "children", "noLabel", "iconDescription", "hideLabel", "invalid", "invalidText", "helperText", "light", "size", "warn", "warnText"]);

  var selectClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--select"), true), _defineProperty(_classNames, "".concat(prefix, "--select--inline"), inline), _defineProperty(_classNames, "".concat(prefix, "--select--light"), light), _defineProperty(_classNames, "".concat(prefix, "--select--invalid"), invalid), _defineProperty(_classNames, "".concat(prefix, "--select--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix, "--select--warning"), warn), _defineProperty(_classNames, className, className), _classNames));
  var labelClasses = classNames("".concat(prefix, "--label"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames2, "".concat(prefix, "--label--disabled"), disabled), _classNames2));
  var inputClasses = classNames((_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--select-input"), true), _defineProperty(_classNames3, "".concat(prefix, "--select-input--").concat(size), size), _classNames3));
  var errorId = "".concat(id, "-error-msg");

  var errorText = function () {
    if (invalid) {
      return invalidText;
    }

    if (warn) {
      return warnText;
    }
  }();

  var error = invalid || warn ? /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-requirement"),
    id: errorId
  }, errorText) : null;
  var helperTextClasses = classNames("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var helper = helperText ? /*#__PURE__*/React.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;
  var ariaProps = {};

  if (invalid) {
    ariaProps['aria-describedby'] = errorId;
  }

  var input = function () {
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("select", _extends({}, other, ariaProps, {
      id: id,
      className: inputClasses,
      disabled: disabled || undefined,
      "aria-invalid": invalid || undefined,
      ref: ref
    }), children), /*#__PURE__*/React.createElement(ChevronDown16, {
      className: "".concat(prefix, "--select__arrow")
    }), invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
      className: "".concat(prefix, "--select__invalid-icon")
    }), !invalid && warn && /*#__PURE__*/React.createElement(WarningAltFilled16, {
      className: "".concat(prefix, "--select__invalid-icon ").concat(prefix, "--select__invalid-icon--warning")
    }));
  }();

  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-item")
  }, /*#__PURE__*/React.createElement("div", {
    className: selectClasses
  }, !noLabel && /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText), inline && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--select-input--inline__wrapper")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--select-input__wrapper"),
    "data-invalid": invalid || null
  }, input), error), !inline && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--select-input__wrapper"),
    "data-invalid": invalid || null
  }, input), !inline && error ? error : helper));
});
Select.displayName = 'Select';
Select.propTypes = {
  /**
   * Provide the contents of your Select
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the node containing the label and the select box
   */
  className: PropTypes.string,

  /**
   * Optionally provide the default value of the `<select>`
   */
  defaultValue: PropTypes.any,

  /**
   * Specify whether the control is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: PropTypes.node,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide a description for the twistie icon that can be read by screen readers
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop for `Select` is no longer needed and has ' + 'been deprecated. It will be moved in the next major release.'),

  /**
   * Specify a custom `id` for the `<select>`
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: PropTypes.bool,

  /**
   * Specify if the currently value is invalid.
   */
  invalid: PropTypes.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: PropTypes.node,

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: PropTypes.node,

  /**
   * Specify whether you want the light version of this control
   */
  light: PropTypes.bool,

  /**
   * Reserved for use with <Pagination> component. Will not render a label for the
   * select since Pagination renders one for us.
   */
  noLabel: PropTypes.bool,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: PropTypes.func,

  /**
   * Specify the size of the Select Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
};
Select.defaultProps = {
  disabled: false,
  labelText: 'Select',
  inline: false,
  invalid: false,
  invalidText: '',
  helperText: '',
  light: false
};
export default Select;