/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { withKnobs, select } from '@storybook/addon-knobs';
import SkeletonPlaceholder from '../SkeletonPlaceholder';
import mdx from './SkeletonPlaceholder.mdx';
var classNames = {
  'my--skeleton__placeholder--small': 'my--skeleton__placeholder--small',
  'my--skeleton__placeholder--medium': 'my--skeleton__placeholder--medium',
  'my--skeleton__placeholder--large': 'my--skeleton__placeholder--large'
};

var props = function props() {
  return {
    className: select('Classes with different sizes', classNames)
  };
};

export default {
  title: 'Components/Skeleton',
  decorators: [withKnobs],
  parameters: {
    component: SkeletonPlaceholder,
    docs: {
      page: mdx
    }
  }
};
export var _SkeletonPlaceholder = function _SkeletonPlaceholder() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      height: '250px',
      width: '250px'
    }
  }, /*#__PURE__*/React.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: "\n      .my--skeleton__placeholder--small {\n        height: 100px;\n        width: 100px;\n      }\n\n      .my--skeleton__placeholder--medium {\n        height: 150px;\n        width: 150px;\n      }\n\n      .my--skeleton__placeholder--large {\n        height: 250px;\n        width: 250px;\n      }\n    "
    }
  }), /*#__PURE__*/React.createElement(SkeletonPlaceholder, props()));
};