/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { withKnobs, boolean, number, select } from '@storybook/addon-knobs';
import SkeletonText from '../SkeletonText';
import mdx from './SkeletonText.mdx';
var widths = {
  '100%': '100%',
  '250px': '250px'
};

var props = function props() {
  return {
    heading: boolean('Skeleton text at a larger size (heading)'),
    paragraph: boolean('Use multiple lines of text (paragraph)'),
    lineCount: number('The number of lines in a paragraph (lineCount)', 3),
    width: select('Width (in px or %) of single line of text or max-width of paragraph lines (width)', widths, '100%')
  };
};

export default {
  title: 'Components/Skeleton',
  decorators: [withKnobs],
  parameters: {
    component: SkeletonText,
    docs: {
      page: mdx
    }
  }
};
export var _SkeletonText = function _SkeletonText() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/React.createElement(SkeletonText, props()));
};