"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentSwitcherPlayground = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ContentSwitcher = _interopRequireDefault(require("../ContentSwitcher"));

var _Switch = _interopRequireDefault(require("../Switch"));

var _ContentSwitcher2 = _interopRequireDefault(require("./ContentSwitcher.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var selectionModes = {
  'Change selection automatically upon focus (automatic)': 'automatic',
  'Change selection on explicit gesture (manual)': 'manual'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  contentSwitcher: function contentSwitcher() {
    return {
      light: (0, _addonKnobs.boolean)('[Deprecated]: Light variant (light)', false),
      selectedIndex: (0, _addonKnobs.select)('Selected index (selectedIndex)', [0, 1, 2], 0),
      selectionMode: (0, _addonKnobs.select)('Selection mode (selectionMode)', selectionModes, 'automatic'),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  switch: function _switch() {
    return {
      onClick: (0, _addonActions.action)('onClick - Switch'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false)
    };
  }
};
var _default = {
  title: 'Components/ContentSwitcher',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _ContentSwitcher.default,
    subcomponents: {
      Switch: _Switch.default
    },
    docs: {
      page: _ContentSwitcher2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_ContentSwitcher.default, {
    onChange: function onChange() {}
  }, /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "three",
    text: "Third section"
  }));
};

exports.Default = Default;
Default.story = {
  name: 'Content Switcher'
};

var ContentSwitcherPlayground = function ContentSwitcherPlayground() {
  var switchProps = props.switch();
  return /*#__PURE__*/_react.default.createElement(_ContentSwitcher.default, props.contentSwitcher(), /*#__PURE__*/_react.default.createElement(_Switch.default, _extends({
    name: "one",
    text: "First section"
  }, switchProps)), /*#__PURE__*/_react.default.createElement(_Switch.default, _extends({
    name: "two",
    text: "Second section"
  }, switchProps)), /*#__PURE__*/_react.default.createElement(_Switch.default, _extends({
    name: "three",
    text: "Third section"
  }, switchProps)));
};

exports.ContentSwitcherPlayground = ContentSwitcherPlayground;