"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Copy;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _events = require("../../tools/events");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Copy(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      feedback = _ref.feedback,
      feedbackTimeout = _ref.feedbackTimeout,
      onAnimationEnd = _ref.onAnimationEnd,
      onClick = _ref.onClick,
      other = _objectWithoutProperties(_ref, ["children", "className", "feedback", "feedbackTimeout", "onAnimationEnd", "onClick"]);

  var _useState = (0, _react.useState)(''),
      _useState2 = _slicedToArray(_useState, 2),
      animation = _useState2[0],
      setAnimation = _useState2[1];

  var classNames = (0, _classnames2.default)(className, "".concat(prefix, "--copy"), (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--copy-btn--animating"), animation), _defineProperty(_classnames, "".concat(prefix, "--copy-btn--").concat(animation), animation), _classnames)); // eslint-disable-next-line react-hooks/exhaustive-deps

  var handleFadeOut = (0, _react.useCallback)((0, _lodash.default)(function () {
    setAnimation('fade-out');
  }, feedbackTimeout), [feedbackTimeout]);
  var handleClick = (0, _react.useCallback)(function () {
    setAnimation('fade-in');
    handleFadeOut();
  }, [handleFadeOut]);

  var handleAnimationEnd = function handleAnimationEnd(event) {
    if (event.animationName === 'hide-feedback') {
      setAnimation('');
    }
  };

  (0, _react.useEffect)(function () {
    return function () {
      handleFadeOut.cancel();
    };
  }, [handleFadeOut]);
  return /*#__PURE__*/_react.default.createElement("button", _extends({
    type: "button",
    className: classNames,
    onClick: (0, _events.composeEventHandlers)([onClick, handleClick]),
    onAnimationEnd: (0, _events.composeEventHandlers)([onAnimationEnd, handleAnimationEnd])
  }, other, {
    "aria-live": "polite",
    "aria-label": !children && (animation ? feedback : other['aria-label']) || null
  }), children, animation ? feedback : other['aria-label'], /*#__PURE__*/_react.default.createElement("span", {
    "aria-hidden": "true",
    className: "".concat(prefix, "--assistive-text ").concat(prefix, "--copy-btn__feedback")
  }, feedback));
}

Copy.propTypes = {
  /**
   * Pass in content to be rendred in the underlying `<button>`
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: _propTypes.default.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: _propTypes.default.number,

  /**
   * Specify an optional `onAnimationEnd` handler that is called when the underlying
   * animation ends
   */
  onAnimationEnd: _propTypes.default.func,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: _propTypes.default.func
};
Copy.defaultProps = {
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};