"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var DatePickerSkeleton = function DatePickerSkeleton(_ref) {
  var range = _ref.range,
      id = _ref.id,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["range", "id", "className"]);

  var dateInput = /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--date-picker-container")
  },
  /*#__PURE__*/

  /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
  _react.default.createElement("label", {
    className: "".concat(prefix, "--label"),
    htmlFor: id
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--date-picker__input ").concat(prefix, "--skeleton")
  }));

  if (range) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--form-item")
    }, /*#__PURE__*/_react.default.createElement("div", _extends({
      className: (0, _classnames.default)("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--range"), "".concat(prefix, "--skeleton"), className)
    }, rest), dateInput, dateInput));
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-item")
  }, /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--short"), "".concat(prefix, "--date-picker--simple"), "".concat(prefix, "--skeleton"), className)
  }, rest), dateInput));
};

DatePickerSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Specify the id to add.
   */
  id: _propTypes.default.string,

  /**
   * Specify whether the skeleton should be of range date picker.
   */
  range: _propTypes.default.bool
};
var _default = DatePickerSkeleton;
exports.default = _default;