"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Playground = exports.Inline = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Dropdown = _interopRequireDefault(require("../Dropdown"));

var _Dropdown2 = _interopRequireDefault(require("./Dropdown.Skeleton"));

var _Dropdown3 = _interopRequireDefault(require("./Dropdown.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var items = [{
  id: 'option-0',
  text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3'
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};
var types = {
  Default: 'default',
  Inline: 'inline'
};

var props = function props() {
  return {
    id: (0, _addonKnobs.text)('Dropdown ID (id)', 'carbon-dropdown-example'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
    direction: (0, _addonKnobs.select)('Dropdown direction (direction)', directions, 'bottom'),
    label: (0, _addonKnobs.text)('Label (label)', 'Dropdown menu options'),
    ariaLabel: (0, _addonKnobs.text)('Aria Label (ariaLabel)', 'Dropdown'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    titleText: (0, _addonKnobs.text)('Title (titleText)', 'Dropdown label'),
    hideLabel: (0, _addonKnobs.boolean)('No title text shown (hideLabel)', false),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'This is some helper text.'),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'A valid value is required'),
    type: (0, _addonKnobs.select)('Type (type)', types, 'default'),
    warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
    warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This mode may perform worse on older machines'),
    listBoxMenuIconTranslationIds: (0, _addonKnobs.object)('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu'
    })
  };
};

var _default = {
  title: 'Components/Dropdown',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Dropdown.default,
    subcomponents: {
      DropdownSkeleton: _Dropdown2.default
    },
    docs: {
      page: _Dropdown3.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: (0, _addonActions.action)('onChange')
  }));
};

exports.Default = Default;

var Inline = function Inline() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "inline",
    titleText: "Inline dropdown label",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: (0, _addonActions.action)('onChange')
  }));
};

exports.Inline = Inline;

var Playground = function Playground() {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      dropdownProps = _objectWithoutProperties(_props, ["listBoxMenuIconTranslationIds"]);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown.default, _extends({}, dropdownProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    }
  })));
};

exports.Playground = Playground;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_Dropdown2.default, null));
};

exports.Skeleton = Skeleton;