"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _FormGroup = _interopRequireDefault(require("./FormGroup"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _RadioButtonGroup = _interopRequireDefault(require("../RadioButtonGroup"));

var _RadioButton = _interopRequireDefault(require("../RadioButton"));

var _Button = _interopRequireDefault(require("../Button"));

var _FormGroup2 = _interopRequireDefault(require("./FormGroup.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    legendText: (0, _addonKnobs.text)('Legend (legendText)', 'FormGroup Legend'),
    hasMargin: (0, _addonKnobs.boolean)('Fieldset has bottom margin (hasMargin)', true)
  };
};

var _default = {
  title: 'Components/FormGroup',
  parameters: {
    component: _FormGroup.default,
    docs: {
      page: _FormGroup2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_FormGroup.default, {
    legendText: "FormGroup Legend",
    style: {
      maxWidth: '400px'
    }
  }, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "one",
    labelText: "First Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "two",
    labelText: "Last Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  })));
};

exports._Default = _Default;
_Default.story = {
  name: 'Form Group'
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_FormGroup.default, _extends({
    className: "test"
  }, props(), {
    style: {
      maxWidth: '400px'
    }
  }), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "one",
    labelText: "First Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "two",
    labelText: "Last Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }))), /*#__PURE__*/_react.default.createElement(_Button.default, null, "Submit"));
};

exports.Playground = Playground;