"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = Section;
exports.Heading = Heading;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var HeadingContext = /*#__PURE__*/_react.default.createContext(1);

function Section(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'section' : _ref$as,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["as", "children"]);

  var level = _react.default.useContext(HeadingContext);

  return /*#__PURE__*/_react.default.createElement(HeadingContext.Provider, {
    value: Math.min(level + 1, 6)
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, rest, children));
}

Section.propTypes = {
  /**
   * Provide an alternative tag or component to use instead of the default
   * <section> element
   */
  as: _propTypes.default.elementType,

  /**
   * Specify the content that will be placed in the component
   */
  children: _propTypes.default.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: _propTypes.default.string
};

function Heading(props) {
  var level = _react.default.useContext(HeadingContext);

  return /*#__PURE__*/_react.default.createElement("h".concat(level), props);
}

Heading.propTypes = {
  /**
   * Specify the content that will be placed in the component
   */
  children: _propTypes.default.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: _propTypes.default.string
};