"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationActionButton = NotificationActionButton;
exports.NotificationButton = NotificationButton;
exports.ToastNotification = ToastNotification;
exports.InlineNotification = InlineNotification;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../../Button"));

var _useIsomorphicEffect = _interopRequireDefault(require("../../../internal/useIsomorphicEffect"));

var _useNoInteractiveChildren = require("../../../internal/useNoInteractiveChildren");

var _keyboard = require("../../../internal/keyboard");

var _iconTypes;

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
/**
 * Conditionally call a callback when the escape key is pressed
 * @param {func} callback - function to be called
 * @param {bool} override - escape hatch to conditionally call the callback
 */

function useEscapeToClose(callback) {
  var override = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

  var handleKeyDown = function handleKeyDown(event) {
    if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape]) && override) {
      callback(event);
    }
  };

  (0, _useIsomorphicEffect.default)(function () {
    document.addEventListener('keydown', handleKeyDown, false);
    return function () {
      return document.removeEventListener('keydown', handleKeyDown, false);
    };
  });
}

function NotificationActionButton(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      onClick = _ref.onClick,
      rest = _objectWithoutProperties(_ref, ["children", "className", "onClick"]);

  var className = (0, _classnames.default)(customClassName, "".concat(prefix, "--inline-notification__action-button"));
  return /*#__PURE__*/_react.default.createElement(_Button.default, _extends({
    className: className,
    kind: "ghost",
    onClick: onClick,
    size: "small"
  }, rest), children);
}

NotificationActionButton.propTypes = {
  /**
   * Specify the content of the notification action button.
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the notification action button
   */
  className: _propTypes.default.string,

  /**
   * Optionally specify a click handler for the notification action button.
   */
  onClick: _propTypes.default.func
};

function NotificationButton(_ref2) {
  var ariaLabel = _ref2.ariaLabel,
      className = _ref2.className,
      iconDescription = _ref2.iconDescription,
      type = _ref2.type,
      IconTag = _ref2.renderIcon,
      name = _ref2.name,
      notificationType = _ref2.notificationType,
      rest = _objectWithoutProperties(_ref2, ["ariaLabel", "className", "iconDescription", "type", "renderIcon", "name", "notificationType"]);

  var buttonClassName = (0, _classnames.default)(className, _defineProperty({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-button"), notificationType));
  var iconClassName = (0, _classnames.default)(_defineProperty({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-icon"), notificationType));
  return /*#__PURE__*/_react.default.createElement("button", _extends({}, rest, {
    // eslint-disable-next-line react/button-has-type
    type: type,
    "aria-label": iconDescription,
    title: iconDescription,
    className: buttonClassName
  }), IconTag && /*#__PURE__*/_react.default.createElement(IconTag, {
    "aria-label": ariaLabel,
    className: iconClassName,
    name: name
  }));
}

NotificationButton.propTypes = {
  /**
   * Specify a label to be read by screen readers on the notification button
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the notification button
   */
  className: _propTypes.default.string,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an optional icon for the Button through a string,
   * if something but regular "close" icon is desirable
   */
  name: _propTypes.default.string,

  /**
   * Specify the notification type
   */
  notificationType: _propTypes.default.oneOf(['toast', 'inline']),

  /**
   * Optional prop to allow overriding the icon rendering.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Optional prop to specify the type of the Button
   */
  type: _propTypes.default.string
};
NotificationButton.defaultProps = {
  ariaLabel: 'close notification',
  // TODO: deprecate this prop
  notificationType: 'toast',
  type: 'button',
  iconDescription: 'close icon',
  renderIcon: _iconsReact.Close20
};
var iconTypes = (_iconTypes = {
  error: _iconsReact.ErrorFilled20,
  success: _iconsReact.CheckmarkFilled20,
  warning: _iconsReact.WarningFilled20
}, _defineProperty(_iconTypes, 'warning-alt', _iconsReact.WarningAltFilled20), _defineProperty(_iconTypes, "info", _iconsReact.InformationFilled20), _defineProperty(_iconTypes, 'info-square', _iconsReact.InformationSquareFilled20), _iconTypes);

function NotificationIcon(_ref3) {
  var iconDescription = _ref3.iconDescription,
      kind = _ref3.kind,
      notificationType = _ref3.notificationType;
  var IconForKind = iconTypes[kind];

  if (!IconForKind) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement(IconForKind, {
    className: "".concat(prefix, "--").concat(notificationType, "-notification__icon")
  }, /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
}

NotificationIcon.propTypes = {
  iconDescription: _propTypes.default.string.isRequired,
  kind: _propTypes.default.oneOf(['error', 'success', 'warning', 'warning-alt', 'info', 'info-square']).isRequired,
  notificationType: _propTypes.default.oneOf(['inline', 'toast']).isRequired
};

function ToastNotification(_ref4) {
  var _cx3;

  var role = _ref4.role,
      onClose = _ref4.onClose,
      onCloseButtonClick = _ref4.onCloseButtonClick,
      iconDescription = _ref4.iconDescription,
      statusIconDescription = _ref4.statusIconDescription,
      className = _ref4.className,
      children = _ref4.children,
      kind = _ref4.kind,
      lowContrast = _ref4.lowContrast,
      hideCloseButton = _ref4.hideCloseButton,
      timeout = _ref4.timeout,
      closeOnEscape = _ref4.closeOnEscape,
      rest = _objectWithoutProperties(_ref4, ["role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "children", "kind", "lowContrast", "hideCloseButton", "timeout", "closeOnEscape"]);

  var _useState = (0, _react.useState)(true),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var containerClassName = (0, _classnames.default)(className, (_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--toast-notification"), true), _defineProperty(_cx3, "".concat(prefix, "--toast-notification--low-contrast"), lowContrast), _defineProperty(_cx3, "".concat(prefix, "--toast-notification--").concat(kind), kind), _cx3));
  var ref = (0, _react.useRef)(null);
  (0, _useNoInteractiveChildren.useNoInteractiveChildren)(ref);

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  useEscapeToClose(handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  var savedOnClose = (0, _react.useRef)(onClose);
  (0, _react.useEffect)(function () {
    savedOnClose.current = onClose;
  });
  (0, _react.useEffect)(function () {
    if (!timeout) {
      return;
    }

    var timeoutId = window.setTimeout(function (event) {
      setIsOpen(false);

      if (savedOnClose.current) {
        savedOnClose.current(event);
      }
    }, timeout);
    return function () {
      window.clearTimeout(timeoutId);
    };
  }, [timeout]);

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement("div", _extends({}, rest, {
    role: role,
    className: containerClassName
  }), /*#__PURE__*/_react.default.createElement(NotificationIcon, {
    notificationType: "toast",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    className: "".concat(prefix, "--toast-notification__content")
  }, children), !hideCloseButton && /*#__PURE__*/_react.default.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "toast",
    onClick: handleCloseButtonClick,
    "aria-hidden": "true"
  }));
}

ToastNotification.propTypes = {
  /**
   * Specify the content
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: _propTypes.default.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: _propTypes.default.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: _propTypes.default.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify what state the notification represents
   */
  kind: _propTypes.default.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the ToastNotification.
   */
  lowContrast: _propTypes.default.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: _propTypes.default.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side
   */
  role: _propTypes.default.oneOf(['alert', 'log', 'status']).isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: _propTypes.default.string,

  /**
   * Specify an optional duration the notification should be closed in
   */
  timeout: _propTypes.default.number
};
ToastNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  timeout: 0,
  closeOnEscape: true
};

function InlineNotification(_ref5) {
  var _cx4;

  var actions = _ref5.actions,
      children = _ref5.children,
      initialRole = _ref5.role,
      onClose = _ref5.onClose,
      onCloseButtonClick = _ref5.onCloseButtonClick,
      iconDescription = _ref5.iconDescription,
      statusIconDescription = _ref5.statusIconDescription,
      className = _ref5.className,
      kind = _ref5.kind,
      lowContrast = _ref5.lowContrast,
      hideCloseButton = _ref5.hideCloseButton,
      hasFocus = _ref5.hasFocus,
      closeOnEscape = _ref5.closeOnEscape,
      rest = _objectWithoutProperties(_ref5, ["actions", "children", "role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "kind", "lowContrast", "hideCloseButton", "hasFocus", "closeOnEscape"]);

  var _useState3 = (0, _react.useState)(true),
      _useState4 = _slicedToArray(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1];

  var containerClassName = (0, _classnames.default)(className, (_cx4 = {}, _defineProperty(_cx4, "".concat(prefix, "--inline-notification"), true), _defineProperty(_cx4, "".concat(prefix, "--inline-notification--low-contrast"), lowContrast), _defineProperty(_cx4, "".concat(prefix, "--inline-notification--").concat(kind), kind), _defineProperty(_cx4, "".concat(prefix, "--inline-notification--hide-close-button"), hideCloseButton), _cx4)); // Placing interactable element(s) within a notification requires a role of
  // alertdialog. Additionaly, focus must be automatically moved to the component.

  var role = actions ? 'alertdialog' : initialRole;
  var ref = (0, _react.useRef)(null);
  (0, _useIsomorphicEffect.default)(function () {
    if (ref.current && role == 'alertdialog' && hasFocus) {
      ref.current.focus();
    }
  });

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  useEscapeToClose(handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement("div", _extends({}, rest, {
    ref: ref,
    role: role,
    className: containerClassName
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-notification__details")
  }, /*#__PURE__*/_react.default.createElement(NotificationIcon, {
    notificationType: "inline",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-notification__text-wrapper")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-notification__content")
  }, children))), actions, !hideCloseButton && /*#__PURE__*/_react.default.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "inline",
    onClick: handleCloseButtonClick,
    "aria-hidden": role === 'alertdialog' ? false : true
  }));
}

InlineNotification.propTypes = {
  /**
   * Pass in the action nodes that will be rendered within the InlineNotification.
   * If this prop is configured, the aria role will be changed to "alertdialog"
   */
  actions: _propTypes.default.node,

  /**
   * Specify the content
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: _propTypes.default.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: _propTypes.default.bool,

  /**
   * Specify if focus should be moved to the component when the notification contains actions
   */
  hasFocus: _propTypes.default.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: _propTypes.default.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify what state the notification represents
   */
  kind: _propTypes.default.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the InlineNotification.
   */
  lowContrast: _propTypes.default.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: _propTypes.default.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side. If the `actions` prop is
   * configured, this will be overridden to "alertdialog".
   */
  role: _propTypes.default.string.isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: _propTypes.default.string
};
InlineNotification.defaultProps = {
  kind: 'error',
  content: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  hasFocus: true,
  closeOnEscape: true
};