"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Example = exports.Indeterminate = exports._ProgressBar = exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _ProgressBar2 = _interopRequireDefault(require("../ProgressBar"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var props = function props() {
  return {
    label: (0, _addonKnobs.text)('Label text (label)', 'Progress bar label'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text'),
    hideLabel: (0, _addonKnobs.boolean)('Hide the label (hideLabel)', false),
    value: (0, _addonKnobs.number)('Current value (value)', 75),
    max: (0, _addonKnobs.number)('Maximum value (max)', 100)
  };
};

var _default = {
  title: 'Experimental/unstable_ProgressBar',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _ProgressBar2.default
  }
};
exports.default = _default;

var _ProgressBar = function _ProgressBar() {
  return /*#__PURE__*/_react.default.createElement(_ProgressBar2.default, {
    label: "Progress bar label",
    helperText: "Optional helper text",
    value: 75
  });
};

exports._ProgressBar = _ProgressBar;
_ProgressBar.storyName = 'ProgressBar';

var Indeterminate = function Indeterminate() {
  return /*#__PURE__*/_react.default.createElement(_ProgressBar2.default, {
    label: "Progress bar label",
    helperText: "Optional helper text"
  });
};

exports.Indeterminate = Indeterminate;

var Example = function Example() {
  var size = 728;

  var _useState = (0, _react.useState)(0),
      _useState2 = _slicedToArray(_useState, 2),
      progress = _useState2[0],
      setProgress = _useState2[1];

  (0, _react.useEffect)(function () {
    setTimeout(function () {
      var interval = setInterval(function () {
        setProgress(function (currentProgress) {
          var advancement = Math.random() * 8;

          if (currentProgress + advancement < size) {
            return currentProgress + advancement;
          } else {
            clearInterval(interval);
            return size;
          }
        });
      }, 50);
    }, 3000);
  }, []);
  var running = progress > 0;
  var helperText = running ? "".concat(progress.toFixed(1), "MB of ").concat(size, "MB") : 'Fetching assets...';

  if (progress >= size) {
    helperText = 'Done';
  }

  return /*#__PURE__*/_react.default.createElement(_ProgressBar2.default, {
    value: running ? progress : null,
    max: size,
    label: "Export data",
    helperText: helperText
  });
};

exports.Example = Example;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_ProgressBar2.default, props());
};

exports.Playground = Playground;