"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._SkeletonText = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _SkeletonText2 = _interopRequireDefault(require("../SkeletonText"));

var _SkeletonText3 = _interopRequireDefault(require("./SkeletonText.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var widths = {
  '100%': '100%',
  '250px': '250px'
};

var props = function props() {
  return {
    heading: (0, _addonKnobs.boolean)('Skeleton text at a larger size (heading)'),
    paragraph: (0, _addonKnobs.boolean)('Use multiple lines of text (paragraph)'),
    lineCount: (0, _addonKnobs.number)('The number of lines in a paragraph (lineCount)', 3),
    width: (0, _addonKnobs.select)('Width (in px or %) of single line of text or max-width of paragraph lines (width)', widths, '100%')
  };
};

var _default = {
  title: 'Components/Skeleton',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _SkeletonText2.default,
    docs: {
      page: _SkeletonText3.default
    }
  }
};
exports.default = _default;

var _SkeletonText = function _SkeletonText() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText2.default, props()));
};

exports._SkeletonText = _SkeletonText;