"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.CustomIcon = exports.Filter = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _iconsReact = require("@carbon/icons-react");

var _Tag = _interopRequireWildcard(require("../Tag"));

var _Tag2 = _interopRequireDefault(require("../Tag/Tag.Skeleton"));

var _preview = require("@storybook/addon-actions/dist/preview");

var _Tag3 = _interopRequireDefault(require("./Tag.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var icons = {
  'Carbon (Carbon16 from `@carbon/icons-react`)': 'Carbon16',
  'Compass (Compass16 from `@carbon/icons-react`)': 'Compass16',
  'Tag (Tag16 from `@carbon/icons-react`)': 'Tag16'
};
var iconMap = {
  Carbon16: _iconsReact.Carbon16,
  Compass16: _iconsReact.Compass16,
  Tag16: _iconsReact.Tag16
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};
var props = {
  regular: function regular() {
    return {
      type: (0, _addonKnobs.select)('Tag type (type)', _Tag.types.reduce(function (acc, type) {
        return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, "".concat(type, " (").concat(type, ")"), type));
      }, {
        Default: undefined
      })),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      title: (0, _addonKnobs.text)('Title (title)', 'Clear Filter')
    };
  },
  filter: function filter() {
    return _objectSpread(_objectSpread({}, this.regular()), {}, {
      onClick: (0, _preview.action)('onClick'),
      onClose: (0, _preview.action)('onClose')
    });
  },
  icon: function icon() {
    return _objectSpread(_objectSpread({}, this.regular()), {}, {
      renderIcon: iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'Tag16')]
    });
  }
};
var _default = {
  title: 'Components/Tag',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Tag.default,
    docs: {
      page: _Tag3.default
    },
    subcomponents: {
      TagSkeleton: _Tag2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Tag.default, _extends({
    className: "some-class"
  }, props.regular()), (0, _addonKnobs.text)('Content (children)', 'This is a tag')), /*#__PURE__*/_react.default.createElement(_Tag.default, _extends({
    className: "some-class"
  }, props.regular(), {
    onClick: (0, _preview.action)('onClick')
  }), "This is an interactive tag"));
};

exports._Default = _Default;
_Default.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};

var Filter = function Filter() {
  return /*#__PURE__*/_react.default.createElement(_Tag.default, _extends({
    className: "some-class"
  }, props.filter(), {
    filter: true
  }), (0, _addonKnobs.text)('Content (children)', 'This is a tag'));
};

exports.Filter = Filter;
Filter.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};

var CustomIcon = function CustomIcon() {
  return /*#__PURE__*/_react.default.createElement(_Tag.default, _extends({
    className: "some-class"
  }, props.icon()), (0, _addonKnobs.text)('Content (children)', 'This is a tag'));
};

exports.CustomIcon = CustomIcon;
CustomIcon.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Tag2.default, null), /*#__PURE__*/_react.default.createElement(_Tag2.default, {
    size: "sm"
  }));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n      Placeholder skeleton state to use when content is loading.\n      "
  }
};