"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _react = _interopRequireDefault(require("react"));

var _PasswordInput = _interopRequireDefault(require("./PasswordInput"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var prefix = _carbonComponents.settings.prefix;
describe('PasswordInput', function () {
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_PasswordInput.default, {
      id: "test",
      className: "extra-class",
      labelText: "testlabel",
      helperText: "testHelper",
      light: true,
      showPasswordLabel: "Show password",
      hidePasswordLabel: "Hide password"
    }));

    var passwordInput = function passwordInput() {
      return wrapper.find('input');
    };

    describe('input', function () {
      it('renders as expected', function () {
        expect(passwordInput().length).toBe(1);
      });
      it('should accept refs', function () {
        var MyComponent = /*#__PURE__*/function (_React$Component) {
          _inherits(MyComponent, _React$Component);

          var _super = _createSuper(MyComponent);

          function MyComponent(props) {
            var _this;

            _classCallCheck(this, MyComponent);

            _this = _super.call(this, props);
            _this.passwordInput = /*#__PURE__*/_react.default.createRef();
            _this.focus = _this.focus.bind(_assertThisInitialized(_this));
            return _this;
          }

          _createClass(MyComponent, [{
            key: "focus",
            value: function focus() {
              this.passwordInput.current.focus();
            }
          }, {
            key: "render",
            value: function render() {
              return /*#__PURE__*/_react.default.createElement(_PasswordInput.default, {
                id: "test",
                labelText: "testlabel",
                ref: this.passwordInput
              });
            }
          }]);

          return MyComponent;
        }(_react.default.Component);

        var container = document.createElement('div');
        container.id = 'container';
        document.body.appendChild(container);
        var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(MyComponent, null), {
          attachTo: document.querySelector('#container')
        });
        expect(document.activeElement.type).toBeUndefined();
        wrapper.instance().focus();
        expect(document.activeElement.type).toEqual('password');
      });
      it('has the expected classes', function () {
        expect(passwordInput().hasClass("".concat(prefix, "--text-input"))).toEqual(true);
      });
      it('should add extra classes that are passed via className', function () {
        expect(passwordInput().hasClass('extra-class')).toEqual(true);
      });
      it('has the expected classes for light', function () {
        wrapper.setProps({
          light: true
        });
        expect(passwordInput().hasClass("".concat(prefix, "--text-input--light"))).toEqual(true);
      });
      it('should set type as expected', function () {
        expect(passwordInput().props().type).toEqual('password');
        wrapper.find('button').simulate('click');
        expect(passwordInput().props().type).toEqual('text');
        wrapper.find('button').simulate('click');
        expect(passwordInput().props().type).toEqual('password');
      });
      it('should set value as expected', function () {
        expect(passwordInput().props().defaultValue).toEqual(undefined);
        wrapper.setProps({
          defaultValue: 'test'
        });
        expect(passwordInput().props().defaultValue).toEqual('test');
      });
      it('should set disabled as expected', function () {
        expect(passwordInput().props().disabled).toEqual(false);
        wrapper.setProps({
          disabled: true
        });
        expect(passwordInput().props().disabled).toEqual(true);
      });
      it('should set placeholder as expected', function () {
        expect(passwordInput().props().placeholder).not.toBeDefined();
        wrapper.setProps({
          placeholder: 'Enter text'
        });
        expect(passwordInput().props().placeholder).toEqual('Enter text');
      });
      it('should set password visibility toggle text as expected', function () {
        var _wrapper$props = wrapper.props(),
            hidePasswordLabel = _wrapper$props.hidePasswordLabel,
            showPasswordLabel = _wrapper$props.showPasswordLabel;

        wrapper.setProps({
          disabled: false
        });
        expect(wrapper.find('.bx--text-input--password__visibility__toggle').text()).toEqual(showPasswordLabel);
        wrapper.find('.bx--text-input--password__visibility__toggle').simulate('click');
        expect(wrapper.find('.bx--text-input--password__visibility__toggle').text()).toEqual(hidePasswordLabel);
      });
    });
    describe('label', function () {
      wrapper.setProps({
        labelText: 'Password Input'
      });
      var renderedLabel = wrapper.find('label');
      it('renders a label', function () {
        expect(renderedLabel.length).toBe(1);
      });
      it('has the expected classes', function () {
        expect(renderedLabel.hasClass("".concat(prefix, "--label"))).toEqual(true);
      });
      it('should set label as expected', function () {
        expect(renderedLabel.text()).toEqual('Password Input');
      });
    });
    describe('helper', function () {
      it('renders a helper', function () {
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.length).toEqual(1);
      });
      it('renders children as expected', function () {
        wrapper.setProps({
          helperText: /*#__PURE__*/_react.default.createElement("span", null, "This helper text has ", /*#__PURE__*/_react.default.createElement("a", {
            href: "/"
          }, "a link"), ".")
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.props().children).toEqual( /*#__PURE__*/_react.default.createElement("span", null, "This helper text has ", /*#__PURE__*/_react.default.createElement("a", {
          href: "/"
        }, "a link"), "."));
      });
      it('should set helper text as expected', function () {
        wrapper.setProps({
          helperText: 'Helper text'
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.text()).toEqual('Helper text');
      });
    });
  });
  describe('events', function () {
    describe('disabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_PasswordInput.default, {
        id: "test",
        labelText: "testlabel",
        onClick: onClick,
        onChange: onChange,
        disabled: true
      }));
      var input = wrapper.find('input');
      it('should not invoke onClick', function () {
        input.simulate('click');
        expect(onClick).not.toBeCalled();
      });
      it('should not invoke onChange', function () {
        input.simulate('change');
        expect(onChange).not.toBeCalled();
      });
    });
    describe('enabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_PasswordInput.default, {
        labelText: "testlabel",
        id: "test",
        onClick: onClick,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var eventObject = {
        target: {
          defaultValue: 'test'
        }
      };
      it('should invoke onClick when input is clicked', function () {
        input.simulate('click');
        expect(onClick).toBeCalled();
      });
      it('should invoke onChange when input value is changed', function () {
        input.simulate('change', eventObject);
        expect(onChange).toBeCalledWith(eventObject);
      });
    });
  });
});