"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toggle = Toggle;
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _useControllableState3 = require("../../../internal/useControllableState");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Toggle(_ref) {
  var className = _ref.className,
      _ref$defaultToggled = _ref.defaultToggled,
      defaultToggled = _ref$defaultToggled === void 0 ? false : _ref$defaultToggled,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$hideLabel = _ref.hideLabel,
      hideLabel = _ref$hideLabel === void 0 ? false : _ref$hideLabel,
      id = _ref.id,
      _ref$labelA = _ref.labelA,
      labelA = _ref$labelA === void 0 ? 'Off' : _ref$labelA,
      _ref$labelB = _ref.labelB,
      labelB = _ref$labelB === void 0 ? 'On' : _ref$labelB,
      labelText = _ref.labelText,
      onClick = _ref.onClick,
      onToggle = _ref.onToggle,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'md' : _ref$size,
      toggled = _ref.toggled,
      other = _objectWithoutProperties(_ref, ["className", "defaultToggled", "disabled", "hideLabel", "id", "labelA", "labelB", "labelText", "onClick", "onToggle", "size", "toggled"]);

  var _useControllableState = (0, _useControllableState3.useControllableState)(toggled, onToggle, defaultToggled),
      _useControllableState2 = _slicedToArray(_useControllableState, 2),
      checked = _useControllableState2[0],
      setChecked = _useControllableState2[1];

  function handleClick(e) {
    setChecked(!checked);

    if (onClick) {
      onClick(e);
    }
  }

  var isSm = size === 'sm';
  var sideLabel = hideLabel ? labelText : checked ? labelB : labelA;
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--toggle"), _defineProperty({}, "".concat(prefix, "--toggle--disabled"), disabled), className);
  var labelTextClasses = (0, _classnames.default)("".concat(prefix, "--toggle__label-text"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var appearanceClasses = (0, _classnames.default)("".concat(prefix, "--toggle__appearance"), _defineProperty({}, "".concat(prefix, "--toggle__appearance--sm"), isSm));
  var switchClasses = (0, _classnames.default)("".concat(prefix, "--toggle__switch"), _defineProperty({}, "".concat(prefix, "--toggle__switch--checked"), checked));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("button", _extends({}, other, {
    id: id,
    className: "".concat(prefix, "--toggle__button"),
    role: "switch",
    type: "button",
    "aria-checked": checked,
    disabled: disabled,
    onClick: handleClick
  })), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: "".concat(prefix, "--toggle__label")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: labelTextClasses
  }, labelText), /*#__PURE__*/_react.default.createElement("div", {
    className: appearanceClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: switchClasses
  }, isSm && /*#__PURE__*/_react.default.createElement("svg", {
    className: "".concat(prefix, "--toggle__check"),
    width: "6px",
    height: "5px",
    viewBox: "0 0 6 5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.2 2.7L5 0 6 1 2.2 5 0 2.7 1 1.5z"
  }))), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--toggle__text"),
    "aria-hidden": "true"
  }, sideLabel))));
}

Toggle.propTypes = {
  /**
   * Specify a custom className to apply to the form-item node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the toggle should be on by default
   */
  defaultToggled: _propTypes.default.bool,

  /**
   * Whether this control should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide an id that unique represents the underlying `<button>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify the label for the "off" position
   */
  labelA: _propTypes.default.node.isRequired,

  /**
   * Specify the label for the "on" position
   */
  labelB: _propTypes.default.node.isRequired,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Provide an event listener that is called when the control is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an event listener that is called when the control is toggled
   */
  onToggle: _propTypes.default.func,

  /**
   * Specify the size of the Toggle. Currently only supports 'sm' or 'md' (default)
   */
  size: _propTypes.default.oneOf(['sm', 'md']),

  /**
   * Specify whether the control is toggled
   */
  toggled: _propTypes.default.bool
};
var _default = Toggle;
exports.default = _default;