"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponents = require("carbon-components");

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _setupGetInstanceId.default)();

var TooltipDefinition = function TooltipDefinition(_ref) {
  var _cx;

  var id = _ref.id,
      className = _ref.className,
      triggerClassName = _ref.triggerClassName,
      children = _ref.children,
      direction = _ref.direction,
      align = _ref.align,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      tooltipText = _ref.tooltipText,
      rest = _objectWithoutProperties(_ref, ["id", "className", "triggerClassName", "children", "direction", "align", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave", "tooltipText"]);

  var _useState = (0, _react.useState)(true),
      _useState2 = _slicedToArray(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      tooltipVisible = _useState4[0],
      setTooltipVisible = _useState4[1];

  var tooltipId = id || "definition-tooltip-".concat(getInstanceId());
  var tooltipClassName = (0, _classnames.default)("".concat(prefix, "--tooltip--definition"), "".concat(prefix, "--tooltip--a11y"), className);
  var tooltipTriggerClasses = (0, _classnames.default)("".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), "".concat(prefix, "--tooltip__trigger--definition"), triggerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--tooltip--").concat(direction), direction), _defineProperty(_cx, "".concat(prefix, "--tooltip--align-").concat(align), align), _defineProperty(_cx, "".concat(prefix, "--tooltip--hidden"), !allowTooltipVisibility), _defineProperty(_cx, "".concat(prefix, "--tooltip--visible"), tooltipVisible), _cx));
  var debounceTooltipVisible = (0, _lodash.default)(function () {
    return setTooltipVisible(false);
  }, 100);

  var handleFocus = function handleFocus() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleBlur = debounceTooltipVisible;

  var handleMouseEnter = function handleMouseEnter() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleMouseLeave = debounceTooltipVisible;
  (0, _react.useEffect)(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape])) {
        setAllowTooltipVisibility(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("span", _extends({}, rest, {
    className: tooltipClassName,
    onMouseEnter: (0, _events.composeEventHandlers)([onMouseEnter, handleMouseEnter]),
    onMouseLeave: (0, _events.composeEventHandlers)([onMouseLeave, handleMouseLeave])
  }), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: tooltipTriggerClasses,
    "aria-describedby": tooltipId,
    onFocus: (0, _events.composeEventHandlers)([onFocus, handleFocus]),
    onBlur: (0, _events.composeEventHandlers)([onBlur, handleBlur])
  }, children), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--assistive-text"),
    id: tooltipId,
    role: "tooltip"
  }, tooltipText));
};

TooltipDefinition.propTypes = {
  /**
   * Specify the alignment (to the trigger button) of the tooltip.
   * Can be one of: start, center, or end.
   */
  align: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Specify the tooltip trigger text that is rendered to the UI for the user to
   * interact with in order to display the tooltip.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the direction of the tooltip. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Optionally specify a custom id for the tooltip. If one is not provided, we
   * generate a unique id for you.
   */
  id: _propTypes.default.string,

  /**
   * The event handler for the `blur` event.
   */
  onBlur: _propTypes.default.func,

  /**
   * The event handler for the `focus` event.
   */
  onFocus: _propTypes.default.func,

  /**
   * The event handler for the `mouseenter` event.
   */
  onMouseEnter: _propTypes.default.func,

  /**
   * The event handler for the `mouseleave` event.
   */
  onMouseLeave: _propTypes.default.func,

  /**
   * Provide the text that will be displayed in the tooltip when it is rendered.
   * TODO: rename this prop (will be a breaking change)
   */
  tooltipText: _propTypes.default.node.isRequired,

  /**
   * The CSS class name of the trigger element
   */
  triggerClassName: _propTypes.default.string
};
TooltipDefinition.defaultProps = {
  direction: 'bottom',
  align: 'start'
};
var _default = TooltipDefinition;
exports.default = _default;